/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PiiEntityType {
    BANK_ACCOUNT_NUMBER("BANK_ACCOUNT_NUMBER"),
    BANK_ROUTING("BANK_ROUTING"),
    CREDIT_DEBIT_NUMBER("CREDIT_DEBIT_NUMBER"),
    CREDIT_DEBIT_CVV("CREDIT_DEBIT_CVV"),
    CREDIT_DEBIT_EXPIRY("CREDIT_DEBIT_EXPIRY"),
    PIN("PIN"),
    EMAIL("EMAIL"),
    ADDRESS("ADDRESS"),
    NAME("NAME"),
    PHONE("PHONE"),
    SSN("SSN"),
    DATE_TIME("DATE_TIME"),
    PASSPORT_NUMBER("PASSPORT_NUMBER"),
    DRIVER_ID("DRIVER_ID"),
    URL("URL"),
    AGE("AGE"),
    USERNAME("USERNAME"),
    PASSWORD("PASSWORD"),
    AWS_ACCESS_KEY("AWS_ACCESS_KEY"),
    AWS_SECRET_KEY("AWS_SECRET_KEY"),
    IP_ADDRESS("IP_ADDRESS"),
    MAC_ADDRESS("MAC_ADDRESS"),
    ALL("ALL"),
    LICENSE_PLATE("LICENSE_PLATE"),
    VEHICLE_IDENTIFICATION_NUMBER("VEHICLE_IDENTIFICATION_NUMBER"),
    UK_NATIONAL_INSURANCE_NUMBER("UK_NATIONAL_INSURANCE_NUMBER"),
    CA_SOCIAL_INSURANCE_NUMBER("CA_SOCIAL_INSURANCE_NUMBER"),
    US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER("US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER"),
    UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER("UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER"),
    IN_PERMANENT_ACCOUNT_NUMBER("IN_PERMANENT_ACCOUNT_NUMBER"),
    IN_NREGA("IN_NREGA"),
    INTERNATIONAL_BANK_ACCOUNT_NUMBER("INTERNATIONAL_BANK_ACCOUNT_NUMBER"),
    SWIFT_CODE("SWIFT_CODE"),
    UK_NATIONAL_HEALTH_SERVICE_NUMBER("UK_NATIONAL_HEALTH_SERVICE_NUMBER"),
    CA_HEALTH_NUMBER("CA_HEALTH_NUMBER"),
    IN_AADHAAR("IN_AADHAAR"),
    IN_VOTER_NUMBER("IN_VOTER_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PiiEntityType> VALUE_MAP;
    private final String value;

    private PiiEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PiiEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PiiEntityType> knownValues() {
        EnumSet<PiiEntityType> knownValues = EnumSet.allOf(PiiEntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PiiEntityType.class, PiiEntityType::toString);
    }
}

