/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRepositoryLinkRequest extends CodeStarConnectionsRequest implements
        ToCopyableBuilder<DeleteRepositoryLinkRequest.Builder, DeleteRepositoryLinkRequest> {
    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkId").getter(getter(DeleteRepositoryLinkRequest::repositoryLinkId))
            .setter(setter(Builder::repositoryLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_LINK_ID_FIELD));

    private final String repositoryLinkId;

    private DeleteRepositoryLinkRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryLinkId = builder.repositoryLinkId;
    }

    /**
     * <p>
     * The ID of the repository link to be deleted.
     * </p>
     * 
     * @return The ID of the repository link to be deleted.
     */
    public final String repositoryLinkId() {
        return repositoryLinkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRepositoryLinkRequest)) {
            return false;
        }
        DeleteRepositoryLinkRequest other = (DeleteRepositoryLinkRequest) obj;
        return Objects.equals(repositoryLinkId(), other.repositoryLinkId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRepositoryLinkRequest").add("RepositoryLinkId", repositoryLinkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryLinkId":
            return Optional.ofNullable(clazz.cast(repositoryLinkId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRepositoryLinkRequest, T> g) {
        return obj -> g.apply((DeleteRepositoryLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRepositoryLinkRequest> {
        /**
         * <p>
         * The ID of the repository link to be deleted.
         * </p>
         * 
         * @param repositoryLinkId
         *        The ID of the repository link to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkId(String repositoryLinkId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarConnectionsRequest.BuilderImpl implements Builder {
        private String repositoryLinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRepositoryLinkRequest model) {
            super(model);
            repositoryLinkId(model.repositoryLinkId);
        }

        public final String getRepositoryLinkId() {
            return repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRepositoryLinkRequest build() {
            return new DeleteRepositoryLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
