/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.GitPushFilter;
import software.amazon.awssdk.services.codepipeline.model.GitPushFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GitConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GitConfiguration> {
    private static final SdkField<String> SOURCE_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceActionName").getter(GitConfiguration.getter(GitConfiguration::sourceActionName)).setter(GitConfiguration.setter(Builder::sourceActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceActionName").build()}).build();
    private static final SdkField<List<GitPushFilter>> PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("push").getter(GitConfiguration.getter(GitConfiguration::push)).setter(GitConfiguration.setter(Builder::push)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("push").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GitPushFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ACTION_NAME_FIELD, PUSH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceActionName;
    private final List<GitPushFilter> push;

    private GitConfiguration(BuilderImpl builder) {
        this.sourceActionName = builder.sourceActionName;
        this.push = builder.push;
    }

    public final String sourceActionName() {
        return this.sourceActionName;
    }

    public final boolean hasPush() {
        return this.push != null && !(this.push instanceof SdkAutoConstructList);
    }

    public final List<GitPushFilter> push() {
        return this.push;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPush() ? this.push() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitConfiguration)) {
            return false;
        }
        GitConfiguration other = (GitConfiguration)obj;
        return Objects.equals(this.sourceActionName(), other.sourceActionName()) && this.hasPush() == other.hasPush() && Objects.equals(this.push(), other.push());
    }

    public final String toString() {
        return ToString.builder((String)"GitConfiguration").add("SourceActionName", (Object)this.sourceActionName()).add("Push", this.hasPush() ? this.push() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceActionName": {
                return Optional.ofNullable(clazz.cast(this.sourceActionName()));
            }
            case "push": {
                return Optional.ofNullable(clazz.cast(this.push()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitConfiguration, T> g) {
        return obj -> g.apply((GitConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceActionName;
        private List<GitPushFilter> push = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GitConfiguration model) {
            this.sourceActionName(model.sourceActionName);
            this.push(model.push);
        }

        public final String getSourceActionName() {
            return this.sourceActionName;
        }

        public final void setSourceActionName(String sourceActionName) {
            this.sourceActionName = sourceActionName;
        }

        @Override
        public final Builder sourceActionName(String sourceActionName) {
            this.sourceActionName = sourceActionName;
            return this;
        }

        public final List<GitPushFilter.Builder> getPush() {
            List<GitPushFilter.Builder> result = GitPushFilterListCopier.copyToBuilder(this.push);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPush(Collection<GitPushFilter.BuilderImpl> push) {
            this.push = GitPushFilterListCopier.copyFromBuilder(push);
        }

        @Override
        public final Builder push(Collection<GitPushFilter> push) {
            this.push = GitPushFilterListCopier.copy(push);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder push(GitPushFilter ... push) {
            this.push(Arrays.asList(push));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder push(Consumer<GitPushFilter.Builder> ... push) {
            this.push(Stream.of(push).map(c -> (GitPushFilter)((GitPushFilter.Builder)GitPushFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GitConfiguration build() {
            return new GitConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GitConfiguration> {
        public Builder sourceActionName(String var1);

        public Builder push(Collection<GitPushFilter> var1);

        public Builder push(GitPushFilter ... var1);

        public Builder push(Consumer<GitPushFilter.Builder> ... var1);
    }
}

