/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionCategory {
    SOURCE("Source"),
    BUILD("Build"),
    DEPLOY("Deploy"),
    TEST("Test"),
    INVOKE("Invoke"),
    APPROVAL("Approval"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionCategory> VALUE_MAP;
    private final String value;

    private ActionCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionCategory> knownValues() {
        EnumSet<ActionCategory> knownValues = EnumSet.allOf(ActionCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionCategory.class, ActionCategory::toString);
    }
}

