/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output details listed for an action execution, such as the action execution result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecutionOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionExecutionOutput.Builder, ActionExecutionOutput> {
    private static final SdkField<List<ArtifactDetail>> OUTPUT_ARTIFACTS_FIELD = SdkField
            .<List<ArtifactDetail>> builder(MarshallingType.LIST)
            .memberName("outputArtifacts")
            .getter(getter(ActionExecutionOutput::outputArtifacts))
            .setter(setter(Builder::outputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArtifactDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArtifactDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ActionExecutionResult> EXECUTION_RESULT_FIELD = SdkField
            .<ActionExecutionResult> builder(MarshallingType.SDK_POJO).memberName("executionResult")
            .getter(getter(ActionExecutionOutput::executionResult)).setter(setter(Builder::executionResult))
            .constructor(ActionExecutionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build()).build();

    private static final SdkField<Map<String, String>> OUTPUT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("outputVariables")
            .getter(getter(ActionExecutionOutput::outputVariables))
            .setter(setter(Builder::outputVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_ARTIFACTS_FIELD,
            EXECUTION_RESULT_FIELD, OUTPUT_VARIABLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ArtifactDetail> outputArtifacts;

    private final ActionExecutionResult executionResult;

    private final Map<String, String> outputVariables;

    private ActionExecutionOutput(BuilderImpl builder) {
        this.outputArtifacts = builder.outputArtifacts;
        this.executionResult = builder.executionResult;
        this.outputVariables = builder.outputVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputArtifacts() {
        return outputArtifacts != null && !(outputArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of output artifacts of the action that correspond to the action execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputArtifacts} method.
     * </p>
     * 
     * @return Details of output artifacts of the action that correspond to the action execution.
     */
    public final List<ArtifactDetail> outputArtifacts() {
        return outputArtifacts;
    }

    /**
     * <p>
     * Execution result information listed in the output details for an action execution.
     * </p>
     * 
     * @return Execution result information listed in the output details for an action execution.
     */
    public final ActionExecutionResult executionResult() {
        return executionResult;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputVariables() {
        return outputVariables != null && !(outputVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The outputVariables field shows the key-value pairs that were output as part of that execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputVariables} method.
     * </p>
     * 
     * @return The outputVariables field shows the key-value pairs that were output as part of that execution.
     */
    public final Map<String, String> outputVariables() {
        return outputVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputArtifacts() ? outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionResult());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputVariables() ? outputVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionOutput)) {
            return false;
        }
        ActionExecutionOutput other = (ActionExecutionOutput) obj;
        return hasOutputArtifacts() == other.hasOutputArtifacts() && Objects.equals(outputArtifacts(), other.outputArtifacts())
                && Objects.equals(executionResult(), other.executionResult())
                && hasOutputVariables() == other.hasOutputVariables()
                && Objects.equals(outputVariables(), other.outputVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionExecutionOutput").add("OutputArtifacts", hasOutputArtifacts() ? outputArtifacts() : null)
                .add("ExecutionResult", executionResult())
                .add("OutputVariables", hasOutputVariables() ? outputVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputArtifacts":
            return Optional.ofNullable(clazz.cast(outputArtifacts()));
        case "executionResult":
            return Optional.ofNullable(clazz.cast(executionResult()));
        case "outputVariables":
            return Optional.ofNullable(clazz.cast(outputVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionOutput, T> g) {
        return obj -> g.apply((ActionExecutionOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecutionOutput> {
        /**
         * <p>
         * Details of output artifacts of the action that correspond to the action execution.
         * </p>
         * 
         * @param outputArtifacts
         *        Details of output artifacts of the action that correspond to the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Collection<ArtifactDetail> outputArtifacts);

        /**
         * <p>
         * Details of output artifacts of the action that correspond to the action execution.
         * </p>
         * 
         * @param outputArtifacts
         *        Details of output artifacts of the action that correspond to the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(ArtifactDetail... outputArtifacts);

        /**
         * <p>
         * Details of output artifacts of the action that correspond to the action execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #outputArtifacts(List<ArtifactDetail>)}.
         * 
         * @param outputArtifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputArtifacts(java.util.Collection<ArtifactDetail>)
         */
        Builder outputArtifacts(Consumer<ArtifactDetail.Builder>... outputArtifacts);

        /**
         * <p>
         * Execution result information listed in the output details for an action execution.
         * </p>
         * 
         * @param executionResult
         *        Execution result information listed in the output details for an action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionResult(ActionExecutionResult executionResult);

        /**
         * <p>
         * Execution result information listed in the output details for an action execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionExecutionResult.Builder} avoiding
         * the need to create one manually via {@link ActionExecutionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionExecutionResult.Builder#build()} is called immediately and
         * its result is passed to {@link #executionResult(ActionExecutionResult)}.
         * 
         * @param executionResult
         *        a consumer that will call methods on {@link ActionExecutionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionResult(ActionExecutionResult)
         */
        default Builder executionResult(Consumer<ActionExecutionResult.Builder> executionResult) {
            return executionResult(ActionExecutionResult.builder().applyMutation(executionResult).build());
        }

        /**
         * <p>
         * The outputVariables field shows the key-value pairs that were output as part of that execution.
         * </p>
         * 
         * @param outputVariables
         *        The outputVariables field shows the key-value pairs that were output as part of that execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputVariables(Map<String, String> outputVariables);
    }

    static final class BuilderImpl implements Builder {
        private List<ArtifactDetail> outputArtifacts = DefaultSdkAutoConstructList.getInstance();

        private ActionExecutionResult executionResult;

        private Map<String, String> outputVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionOutput model) {
            outputArtifacts(model.outputArtifacts);
            executionResult(model.executionResult);
            outputVariables(model.outputVariables);
        }

        public final List<ArtifactDetail.Builder> getOutputArtifacts() {
            List<ArtifactDetail.Builder> result = ArtifactDetailListCopier.copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputArtifacts(Collection<ArtifactDetail.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = ArtifactDetailListCopier.copyFromBuilder(outputArtifacts);
        }

        @Override
        public final Builder outputArtifacts(Collection<ArtifactDetail> outputArtifacts) {
            this.outputArtifacts = ArtifactDetailListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(ArtifactDetail... outputArtifacts) {
            outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Consumer<ArtifactDetail.Builder>... outputArtifacts) {
            outputArtifacts(Stream.of(outputArtifacts).map(c -> ArtifactDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ActionExecutionResult.Builder getExecutionResult() {
            return executionResult != null ? executionResult.toBuilder() : null;
        }

        public final void setExecutionResult(ActionExecutionResult.BuilderImpl executionResult) {
            this.executionResult = executionResult != null ? executionResult.build() : null;
        }

        @Override
        public final Builder executionResult(ActionExecutionResult executionResult) {
            this.executionResult = executionResult;
            return this;
        }

        public final Map<String, String> getOutputVariables() {
            if (outputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return outputVariables;
        }

        public final void setOutputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
        }

        @Override
        public final Builder outputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
            return this;
        }

        @Override
        public ActionExecutionOutput build() {
            return new ActionExecutionOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
