/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class StageBlockerDeclarationListCopier {
    static List<BlockerDeclaration> copy(Collection<? extends BlockerDeclaration> stageBlockerDeclarationListParam) {
        List<BlockerDeclaration> list;
        if (stageBlockerDeclarationListParam == null || stageBlockerDeclarationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BlockerDeclaration> modifiableList = new ArrayList<>();
            stageBlockerDeclarationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BlockerDeclaration> copyFromBuilder(
            Collection<? extends BlockerDeclaration.Builder> stageBlockerDeclarationListParam) {
        List<BlockerDeclaration> list;
        if (stageBlockerDeclarationListParam == null || stageBlockerDeclarationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BlockerDeclaration> modifiableList = new ArrayList<>();
            stageBlockerDeclarationListParam.forEach(entry -> {
                BlockerDeclaration member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BlockerDeclaration.Builder> copyToBuilder(
            Collection<? extends BlockerDeclaration> stageBlockerDeclarationListParam) {
        List<BlockerDeclaration.Builder> list;
        if (stageBlockerDeclarationListParam == null || stageBlockerDeclarationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BlockerDeclaration.Builder> modifiableList = new ArrayList<>();
            stageBlockerDeclarationListParam.forEach(entry -> {
                BlockerDeclaration.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
