/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineClientBuilder;
import software.amazon.awssdk.services.codepipeline.CodePipelineServiceClientConfiguration;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineBaseClientBuilder;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineClient;
import software.amazon.awssdk.services.codepipeline.endpoints.CodePipelineEndpointProvider;

@SdkInternalApi
final class DefaultCodePipelineClientBuilder
extends DefaultCodePipelineBaseClientBuilder<CodePipelineClientBuilder, CodePipelineClient>
implements CodePipelineClientBuilder {
    DefaultCodePipelineClientBuilder() {
    }

    @Override
    public DefaultCodePipelineClientBuilder endpointProvider(CodePipelineEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodePipelineClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodePipelineClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodePipelineServiceClientConfiguration serviceClientConfiguration = CodePipelineServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodePipelineClient(serviceClientConfiguration, clientConfiguration);
    }
}

