/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.JobWorkerExecutorConfiguration;
import software.amazon.awssdk.services.codepipeline.model.LambdaExecutorConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutorConfiguration> {
    private static final SdkField<LambdaExecutorConfiguration> LAMBDA_EXECUTOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaExecutorConfiguration").getter(ExecutorConfiguration.getter(ExecutorConfiguration::lambdaExecutorConfiguration)).setter(ExecutorConfiguration.setter(Builder::lambdaExecutorConfiguration)).constructor(LambdaExecutorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaExecutorConfiguration").build()}).build();
    private static final SdkField<JobWorkerExecutorConfiguration> JOB_WORKER_EXECUTOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobWorkerExecutorConfiguration").getter(ExecutorConfiguration.getter(ExecutorConfiguration::jobWorkerExecutorConfiguration)).setter(ExecutorConfiguration.setter(Builder::jobWorkerExecutorConfiguration)).constructor(JobWorkerExecutorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobWorkerExecutorConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_EXECUTOR_CONFIGURATION_FIELD, JOB_WORKER_EXECUTOR_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final LambdaExecutorConfiguration lambdaExecutorConfiguration;
    private final JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration;

    private ExecutorConfiguration(BuilderImpl builder) {
        this.lambdaExecutorConfiguration = builder.lambdaExecutorConfiguration;
        this.jobWorkerExecutorConfiguration = builder.jobWorkerExecutorConfiguration;
    }

    public final LambdaExecutorConfiguration lambdaExecutorConfiguration() {
        return this.lambdaExecutorConfiguration;
    }

    public final JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration() {
        return this.jobWorkerExecutorConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaExecutorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobWorkerExecutorConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutorConfiguration)) {
            return false;
        }
        ExecutorConfiguration other = (ExecutorConfiguration)obj;
        return Objects.equals(this.lambdaExecutorConfiguration(), other.lambdaExecutorConfiguration()) && Objects.equals(this.jobWorkerExecutorConfiguration(), other.jobWorkerExecutorConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutorConfiguration").add("LambdaExecutorConfiguration", (Object)this.lambdaExecutorConfiguration()).add("JobWorkerExecutorConfiguration", (Object)this.jobWorkerExecutorConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lambdaExecutorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lambdaExecutorConfiguration()));
            }
            case "jobWorkerExecutorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jobWorkerExecutorConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutorConfiguration, T> g) {
        return obj -> g.apply((ExecutorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LambdaExecutorConfiguration lambdaExecutorConfiguration;
        private JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutorConfiguration model) {
            this.lambdaExecutorConfiguration(model.lambdaExecutorConfiguration);
            this.jobWorkerExecutorConfiguration(model.jobWorkerExecutorConfiguration);
        }

        public final LambdaExecutorConfiguration.Builder getLambdaExecutorConfiguration() {
            return this.lambdaExecutorConfiguration != null ? this.lambdaExecutorConfiguration.toBuilder() : null;
        }

        public final void setLambdaExecutorConfiguration(LambdaExecutorConfiguration.BuilderImpl lambdaExecutorConfiguration) {
            this.lambdaExecutorConfiguration = lambdaExecutorConfiguration != null ? lambdaExecutorConfiguration.build() : null;
        }

        @Override
        public final Builder lambdaExecutorConfiguration(LambdaExecutorConfiguration lambdaExecutorConfiguration) {
            this.lambdaExecutorConfiguration = lambdaExecutorConfiguration;
            return this;
        }

        public final JobWorkerExecutorConfiguration.Builder getJobWorkerExecutorConfiguration() {
            return this.jobWorkerExecutorConfiguration != null ? this.jobWorkerExecutorConfiguration.toBuilder() : null;
        }

        public final void setJobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration.BuilderImpl jobWorkerExecutorConfiguration) {
            this.jobWorkerExecutorConfiguration = jobWorkerExecutorConfiguration != null ? jobWorkerExecutorConfiguration.build() : null;
        }

        @Override
        public final Builder jobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration) {
            this.jobWorkerExecutorConfiguration = jobWorkerExecutorConfiguration;
            return this;
        }

        public ExecutorConfiguration build() {
            return new ExecutorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutorConfiguration> {
        public Builder lambdaExecutorConfiguration(LambdaExecutorConfiguration var1);

        default public Builder lambdaExecutorConfiguration(Consumer<LambdaExecutorConfiguration.Builder> lambdaExecutorConfiguration) {
            return this.lambdaExecutorConfiguration((LambdaExecutorConfiguration)((LambdaExecutorConfiguration.Builder)LambdaExecutorConfiguration.builder().applyMutation(lambdaExecutorConfiguration)).build());
        }

        public Builder jobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration var1);

        default public Builder jobWorkerExecutorConfiguration(Consumer<JobWorkerExecutorConfiguration.Builder> jobWorkerExecutorConfiguration) {
            return this.jobWorkerExecutorConfiguration((JobWorkerExecutorConfiguration)((JobWorkerExecutorConfiguration.Builder)JobWorkerExecutorConfiguration.builder().applyMutation(jobWorkerExecutorConfiguration)).build());
        }
    }
}

