/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event criteria that specify when a webhook notification is sent to your URL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebhookFilterRule implements SdkPojo, Serializable,
        ToCopyableBuilder<WebhookFilterRule.Builder, WebhookFilterRule> {
    private static final SdkField<String> JSON_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jsonPath").getter(getter(WebhookFilterRule::jsonPath)).setter(setter(Builder::jsonPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonPath").build()).build();

    private static final SdkField<String> MATCH_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchEquals").getter(getter(WebhookFilterRule::matchEquals)).setter(setter(Builder::matchEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchEquals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_PATH_FIELD,
            MATCH_EQUALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jsonPath;

    private final String matchEquals;

    private WebhookFilterRule(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
        this.matchEquals = builder.matchEquals;
    }

    /**
     * <p>
     * A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath
     * expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is
     * ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java JsonPath
     * implementation</a> in GitHub.
     * </p>
     * 
     * @return A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the
     *         JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the
     *         request is ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java
     *         JsonPath implementation</a> in GitHub.
     */
    public final String jsonPath() {
        return jsonPath;
    }

    /**
     * <p>
     * The value selected by the <code>JsonPath</code> expression must match what is supplied in the
     * <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action
     * configuration can be included as placeholders in this value by surrounding the action configuration key with
     * curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an
     * action configuration property called "Branch" with a value of "master", the <code>MatchEquals</code> value is
     * evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see <a
     * href=
     * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements"
     * >Pipeline Structure Reference Action Requirements</a>.
     * </p>
     * 
     * @return The value selected by the <code>JsonPath</code> expression must match what is supplied in the
     *         <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action
     *         configuration can be included as placeholders in this value by surrounding the action configuration key
     *         with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target
     *         action has an action configuration property called "Branch" with a value of "master", the
     *         <code>MatchEquals</code> value is evaluated as "refs/heads/master". For a list of action configuration
     *         properties for built-in action types, see <a href=
     *         "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements"
     *         >Pipeline Structure Reference Action Requirements</a>.
     */
    public final String matchEquals() {
        return matchEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonPath());
        hashCode = 31 * hashCode + Objects.hashCode(matchEquals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookFilterRule)) {
            return false;
        }
        WebhookFilterRule other = (WebhookFilterRule) obj;
        return Objects.equals(jsonPath(), other.jsonPath()) && Objects.equals(matchEquals(), other.matchEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebhookFilterRule").add("JsonPath", jsonPath()).add("MatchEquals", matchEquals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jsonPath":
            return Optional.ofNullable(clazz.cast(jsonPath()));
        case "matchEquals":
            return Optional.ofNullable(clazz.cast(matchEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebhookFilterRule, T> g) {
        return obj -> g.apply((WebhookFilterRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebhookFilterRule> {
        /**
         * <p>
         * A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath
         * expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is
         * ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java JsonPath
         * implementation</a> in GitHub.
         * </p>
         * 
         * @param jsonPath
         *        A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the
         *        JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise,
         *        the request is ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java
         *        JsonPath implementation</a> in GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonPath(String jsonPath);

        /**
         * <p>
         * The value selected by the <code>JsonPath</code> expression must match what is supplied in the
         * <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action
         * configuration can be included as placeholders in this value by surrounding the action configuration key with
         * curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an
         * action configuration property called "Branch" with a value of "master", the <code>MatchEquals</code> value is
         * evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types,
         * see <a href=
         * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements"
         * >Pipeline Structure Reference Action Requirements</a>.
         * </p>
         * 
         * @param matchEquals
         *        The value selected by the <code>JsonPath</code> expression must match what is supplied in the
         *        <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action
         *        configuration can be included as placeholders in this value by surrounding the action configuration
         *        key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the
         *        target action has an action configuration property called "Branch" with a value of "master", the
         *        <code>MatchEquals</code> value is evaluated as "refs/heads/master". For a list of action configuration
         *        properties for built-in action types, see <a href=
         *        "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements"
         *        >Pipeline Structure Reference Action Requirements</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchEquals(String matchEquals);
    }

    static final class BuilderImpl implements Builder {
        private String jsonPath;

        private String matchEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookFilterRule model) {
            jsonPath(model.jsonPath);
            matchEquals(model.matchEquals);
        }

        public final String getJsonPath() {
            return jsonPath;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final String getMatchEquals() {
            return matchEquals;
        }

        public final void setMatchEquals(String matchEquals) {
            this.matchEquals = matchEquals;
        }

        @Override
        public final Builder matchEquals(String matchEquals) {
            this.matchEquals = matchEquals;
            return this;
        }

        @Override
        public WebhookFilterRule build() {
            return new WebhookFilterRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
