/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionDetails.Builder, ExecutionDetails> {
    private static final SdkField<String> SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("summary")
            .getter(getter(ExecutionDetails::summary)).setter(setter(Builder::summary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionId").getter(getter(ExecutionDetails::externalExecutionId))
            .setter(setter(Builder::externalExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build())
            .build();

    private static final SdkField<Integer> PERCENT_COMPLETE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("percentComplete").getter(getter(ExecutionDetails::percentComplete))
            .setter(setter(Builder::percentComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentComplete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD,
            EXTERNAL_EXECUTION_ID_FIELD, PERCENT_COMPLETE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String summary;

    private final String externalExecutionId;

    private final Integer percentComplete;

    private ExecutionDetails(BuilderImpl builder) {
        this.summary = builder.summary;
        this.externalExecutionId = builder.externalExecutionId;
        this.percentComplete = builder.percentComplete;
    }

    /**
     * <p>
     * The summary of the current status of the actions.
     * </p>
     * 
     * @return The summary of the current status of the actions.
     */
    public final String summary() {
        return summary;
    }

    /**
     * <p>
     * The system-generated unique ID of this action used to identify this job worker in any external systems, such as
     * AWS CodeDeploy.
     * </p>
     * 
     * @return The system-generated unique ID of this action used to identify this job worker in any external systems,
     *         such as AWS CodeDeploy.
     */
    public final String externalExecutionId() {
        return externalExecutionId;
    }

    /**
     * <p>
     * The percentage of work completed on the action, represented on a scale of 0 to 100 percent.
     * </p>
     * 
     * @return The percentage of work completed on the action, represented on a scale of 0 to 100 percent.
     */
    public final Integer percentComplete() {
        return percentComplete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(percentComplete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionDetails)) {
            return false;
        }
        ExecutionDetails other = (ExecutionDetails) obj;
        return Objects.equals(summary(), other.summary()) && Objects.equals(externalExecutionId(), other.externalExecutionId())
                && Objects.equals(percentComplete(), other.percentComplete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionDetails").add("Summary", summary()).add("ExternalExecutionId", externalExecutionId())
                .add("PercentComplete", percentComplete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "externalExecutionId":
            return Optional.ofNullable(clazz.cast(externalExecutionId()));
        case "percentComplete":
            return Optional.ofNullable(clazz.cast(percentComplete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionDetails, T> g) {
        return obj -> g.apply((ExecutionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionDetails> {
        /**
         * <p>
         * The summary of the current status of the actions.
         * </p>
         * 
         * @param summary
         *        The summary of the current status of the actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(String summary);

        /**
         * <p>
         * The system-generated unique ID of this action used to identify this job worker in any external systems, such
         * as AWS CodeDeploy.
         * </p>
         * 
         * @param externalExecutionId
         *        The system-generated unique ID of this action used to identify this job worker in any external
         *        systems, such as AWS CodeDeploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionId(String externalExecutionId);

        /**
         * <p>
         * The percentage of work completed on the action, represented on a scale of 0 to 100 percent.
         * </p>
         * 
         * @param percentComplete
         *        The percentage of work completed on the action, represented on a scale of 0 to 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentComplete(Integer percentComplete);
    }

    static final class BuilderImpl implements Builder {
        private String summary;

        private String externalExecutionId;

        private Integer percentComplete;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionDetails model) {
            summary(model.summary);
            externalExecutionId(model.externalExecutionId);
            percentComplete(model.percentComplete);
        }

        public final String getSummary() {
            return summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final String getExternalExecutionId() {
            return externalExecutionId;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final Integer getPercentComplete() {
            return percentComplete;
        }

        public final void setPercentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
        }

        @Override
        public final Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            return this;
        }

        @Override
        public ExecutionDetails build() {
            return new ExecutionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
