/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineMetadata.Builder, PipelineMetadata> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineArn").getter(getter(PipelineMetadata::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineArn").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(PipelineMetadata::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updated").getter(getter(PipelineMetadata::updated)).setter(setter(Builder::updated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updated").build()).build();

    private static final SdkField<Instant> POLLING_DISABLED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("pollingDisabledAt").getter(getter(PipelineMetadata::pollingDisabledAt))
            .setter(setter(Builder::pollingDisabledAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pollingDisabledAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            CREATED_FIELD, UPDATED_FIELD, POLLING_DISABLED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final Instant created;

    private final Instant updated;

    private final Instant pollingDisabledAt;

    private PipelineMetadata(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.created = builder.created;
        this.updated = builder.updated;
        this.pollingDisabledAt = builder.pollingDisabledAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The date and time the pipeline was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the pipeline was created, in timestamp format.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time the pipeline was last updated, in timestamp format.
     * </p>
     * 
     * @return The date and time the pipeline was last updated, in timestamp format.
     */
    public final Instant updated() {
        return updated;
    }

    /**
     * <p>
     * The date and time that polling for source changes (periodic checks) was stopped for the pipeline, in timestamp
     * format. You can migrate (update) a polling pipeline to use event-based change detection. For example, for a
     * pipeline with a CodeCommit source, we recommend you migrate (update) your pipeline to use CloudWatch Events. To
     * learn more, see <a
     * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/update-change-detection.html">Migrate polling
     * pipelines to use event-based change detection</a> in the CodePipeline User Guide.
     * </p>
     * 
     * @return The date and time that polling for source changes (periodic checks) was stopped for the pipeline, in
     *         timestamp format. You can migrate (update) a polling pipeline to use event-based change detection. For
     *         example, for a pipeline with a CodeCommit source, we recommend you migrate (update) your pipeline to use
     *         CloudWatch Events. To learn more, see <a
     *         href="https://docs.aws.amazon.com/codepipeline/latest/userguide/update-change-detection.html">Migrate
     *         polling pipelines to use event-based change detection</a> in the CodePipeline User Guide.
     */
    public final Instant pollingDisabledAt() {
        return pollingDisabledAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(updated());
        hashCode = 31 * hashCode + Objects.hashCode(pollingDisabledAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineMetadata)) {
            return false;
        }
        PipelineMetadata other = (PipelineMetadata) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && Objects.equals(created(), other.created())
                && Objects.equals(updated(), other.updated()) && Objects.equals(pollingDisabledAt(), other.pollingDisabledAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineMetadata").add("PipelineArn", pipelineArn()).add("Created", created())
                .add("Updated", updated()).add("PollingDisabledAt", pollingDisabledAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "updated":
            return Optional.ofNullable(clazz.cast(updated()));
        case "pollingDisabledAt":
            return Optional.ofNullable(clazz.cast(pollingDisabledAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineMetadata, T> g) {
        return obj -> g.apply((PipelineMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The date and time the pipeline was created, in timestamp format.
         * </p>
         * 
         * @param created
         *        The date and time the pipeline was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time the pipeline was last updated, in timestamp format.
         * </p>
         * 
         * @param updated
         *        The date and time the pipeline was last updated, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updated(Instant updated);

        /**
         * <p>
         * The date and time that polling for source changes (periodic checks) was stopped for the pipeline, in
         * timestamp format. You can migrate (update) a polling pipeline to use event-based change detection. For
         * example, for a pipeline with a CodeCommit source, we recommend you migrate (update) your pipeline to use
         * CloudWatch Events. To learn more, see <a
         * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/update-change-detection.html">Migrate polling
         * pipelines to use event-based change detection</a> in the CodePipeline User Guide.
         * </p>
         * 
         * @param pollingDisabledAt
         *        The date and time that polling for source changes (periodic checks) was stopped for the pipeline, in
         *        timestamp format. You can migrate (update) a polling pipeline to use event-based change detection. For
         *        example, for a pipeline with a CodeCommit source, we recommend you migrate (update) your pipeline to
         *        use CloudWatch Events. To learn more, see <a
         *        href="https://docs.aws.amazon.com/codepipeline/latest/userguide/update-change-detection.html">Migrate
         *        polling pipelines to use event-based change detection</a> in the CodePipeline User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pollingDisabledAt(Instant pollingDisabledAt);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private Instant created;

        private Instant updated;

        private Instant pollingDisabledAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineMetadata model) {
            pipelineArn(model.pipelineArn);
            created(model.created);
            updated(model.updated);
            pollingDisabledAt(model.pollingDisabledAt);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getUpdated() {
            return updated;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public final Instant getPollingDisabledAt() {
            return pollingDisabledAt;
        }

        public final void setPollingDisabledAt(Instant pollingDisabledAt) {
            this.pollingDisabledAt = pollingDisabledAt;
        }

        @Override
        public final Builder pollingDisabledAt(Instant pollingDisabledAt) {
            this.pollingDisabledAt = pollingDisabledAt;
            return this;
        }

        @Override
        public PipelineMetadata build() {
            return new PipelineMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
