/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUploadUrlResponse extends CodeGuruSecurityResponse implements
        ToCopyableBuilder<CreateUploadUrlResponse.Builder, CreateUploadUrlResponse> {
    private static final SdkField<String> CODE_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeArtifactId").getter(getter(CreateUploadUrlResponse::codeArtifactId))
            .setter(setter(Builder::codeArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeArtifactId").build()).build();

    private static final SdkField<Map<String, String>> REQUEST_HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requestHeaders")
            .getter(getter(CreateUploadUrlResponse::requestHeaders))
            .setter(setter(Builder::requestHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestHeaders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Url")
            .getter(getter(CreateUploadUrlResponse::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_ARTIFACT_ID_FIELD,
            REQUEST_HEADERS_FIELD, S3_URL_FIELD));

    private final String codeArtifactId;

    private final Map<String, String> requestHeaders;

    private final String s3Url;

    private CreateUploadUrlResponse(BuilderImpl builder) {
        super(builder);
        this.codeArtifactId = builder.codeArtifactId;
        this.requestHeaders = builder.requestHeaders;
        this.s3Url = builder.s3Url;
    }

    /**
     * <p>
     * The identifier for the uploaded code resource.
     * </p>
     * 
     * @return The identifier for the uploaded code resource.
     */
    public final String codeArtifactId() {
        return codeArtifactId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestHeaders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestHeaders() {
        return requestHeaders != null && !(requestHeaders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key-value pairs that contain the required headers when uploading your resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestHeaders} method.
     * </p>
     * 
     * @return A set of key-value pairs that contain the required headers when uploading your resource.
     */
    public final Map<String, String> requestHeaders() {
        return requestHeaders;
    }

    /**
     * <p>
     * A pre-signed S3 URL. You can upload the code file you want to scan and add the required
     * <code>requestHeaders</code> using any HTTP client.
     * </p>
     * 
     * @return A pre-signed S3 URL. You can upload the code file you want to scan and add the required
     *         <code>requestHeaders</code> using any HTTP client.
     */
    public final String s3Url() {
        return s3Url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestHeaders() ? requestHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadUrlResponse)) {
            return false;
        }
        CreateUploadUrlResponse other = (CreateUploadUrlResponse) obj;
        return Objects.equals(codeArtifactId(), other.codeArtifactId()) && hasRequestHeaders() == other.hasRequestHeaders()
                && Objects.equals(requestHeaders(), other.requestHeaders()) && Objects.equals(s3Url(), other.s3Url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUploadUrlResponse").add("CodeArtifactId", codeArtifactId())
                .add("RequestHeaders", requestHeaders() == null ? null : "*** Sensitive Data Redacted ***")
                .add("S3Url", s3Url() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeArtifactId":
            return Optional.ofNullable(clazz.cast(codeArtifactId()));
        case "requestHeaders":
            return Optional.ofNullable(clazz.cast(requestHeaders()));
        case "s3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUploadUrlResponse, T> g) {
        return obj -> g.apply((CreateUploadUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateUploadUrlResponse> {
        /**
         * <p>
         * The identifier for the uploaded code resource.
         * </p>
         * 
         * @param codeArtifactId
         *        The identifier for the uploaded code resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeArtifactId(String codeArtifactId);

        /**
         * <p>
         * A set of key-value pairs that contain the required headers when uploading your resource.
         * </p>
         * 
         * @param requestHeaders
         *        A set of key-value pairs that contain the required headers when uploading your resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestHeaders(Map<String, String> requestHeaders);

        /**
         * <p>
         * A pre-signed S3 URL. You can upload the code file you want to scan and add the required
         * <code>requestHeaders</code> using any HTTP client.
         * </p>
         * 
         * @param s3Url
         *        A pre-signed S3 URL. You can upload the code file you want to scan and add the required
         *        <code>requestHeaders</code> using any HTTP client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);
    }

    static final class BuilderImpl extends CodeGuruSecurityResponse.BuilderImpl implements Builder {
        private String codeArtifactId;

        private Map<String, String> requestHeaders = DefaultSdkAutoConstructMap.getInstance();

        private String s3Url;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadUrlResponse model) {
            super(model);
            codeArtifactId(model.codeArtifactId);
            requestHeaders(model.requestHeaders);
            s3Url(model.s3Url);
        }

        public final String getCodeArtifactId() {
            return codeArtifactId;
        }

        public final void setCodeArtifactId(String codeArtifactId) {
            this.codeArtifactId = codeArtifactId;
        }

        @Override
        public final Builder codeArtifactId(String codeArtifactId) {
            this.codeArtifactId = codeArtifactId;
            return this;
        }

        public final Map<String, String> getRequestHeaders() {
            if (requestHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestHeaders;
        }

        public final void setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = RequestHeaderMapCopier.copy(requestHeaders);
        }

        @Override
        public final Builder requestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = RequestHeaderMapCopier.copy(requestHeaders);
            return this;
        }

        public final String getS3Url() {
            return s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        @Override
        public CreateUploadUrlResponse build() {
            return new CreateUploadUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
