/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codegurusecurity.model.AccessDeniedException;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityException;
import software.amazon.awssdk.services.codegurusecurity.model.ConflictException;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.InternalServerException;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ThrottlingException;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ValidationException;
import software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable;

/**
 * Service client for accessing Amazon CodeGuru Security. This can be created using the static {@link #builder()}
 * method.
 *
 * <note>
 * <p>
 * Amazon CodeGuru Security is in preview release and is subject to change.
 * </p>
 * </note>
 * <p>
 * This section provides documentation for the Amazon CodeGuru Security API operations. CodeGuru Security is a service
 * that uses program analysis and machine learning to detect security policy violations and vulnerabilities, and
 * recommends ways to address these security risks.
 * </p>
 * <p>
 * By proactively detecting and providing recommendations for addressing security risks, CodeGuru Security improves the
 * overall security of your application code. For more information about CodeGuru Security, see the <a
 * href="https://docs.aws.amazon.com/codeguru/latest/security-ug/what-is-codeguru-security.html">Amazon CodeGuru
 * Security User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodeGuruSecurityClient extends AwsClient {
    String SERVICE_NAME = "codeguru-security";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codeguru-security";

    /**
     * <p>
     * Returns a list of all requested findings.
     * </p>
     *
     * @param batchGetFindingsRequest
     * @return Result of the BatchGetFindings operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.BatchGetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/BatchGetFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFindingsResponse batchGetFindings(BatchGetFindingsRequest batchGetFindingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all requested findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetFindingsRequest#builder()}
     * </p>
     *
     * @param batchGetFindingsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetFindingsRequest.Builder} to create a request.
     * @return Result of the BatchGetFindings operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.BatchGetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/BatchGetFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFindingsResponse batchGetFindings(Consumer<BatchGetFindingsRequest.Builder> batchGetFindingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        return batchGetFindings(BatchGetFindingsRequest.builder().applyMutation(batchGetFindingsRequest).build());
    }

    /**
     * <p>
     * Use to create a scan using code uploaded to an S3 bucket.
     * </p>
     *
     * @param createScanRequest
     * @return Result of the CreateScan operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.CreateScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateScan" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateScanResponse createScan(CreateScanRequest createScanRequest) throws InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to create a scan using code uploaded to an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScanRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScanRequest#builder()}
     * </p>
     *
     * @param createScanRequest
     *        A {@link Consumer} that will call methods on {@link CreateScanRequest.Builder} to create a request.
     * @return Result of the CreateScan operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.CreateScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateScan" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateScanResponse createScan(Consumer<CreateScanRequest.Builder> createScanRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return createScan(CreateScanRequest.builder().applyMutation(createScanRequest).build());
    }

    /**
     * <p>
     * Generates a pre-signed URL and request headers used to upload a code resource.
     * </p>
     * <p>
     * You can upload your code resource to the URL and add the request headers using any HTTP client.
     * </p>
     *
     * @param createUploadUrlRequest
     * @return Result of the CreateUploadUrl operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUploadUrlResponse createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a pre-signed URL and request headers used to upload a code resource.
     * </p>
     * <p>
     * You can upload your code resource to the URL and add the request headers using any HTTP client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUploadUrlRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUploadUrlRequest#builder()}
     * </p>
     *
     * @param createUploadUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateUploadUrlRequest.Builder} to create a request.
     * @return Result of the CreateUploadUrl operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUploadUrlResponse createUploadUrl(Consumer<CreateUploadUrlRequest.Builder> createUploadUrlRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        return createUploadUrl(CreateUploadUrlRequest.builder().applyMutation(createUploadUrlRequest).build());
    }

    /**
     * <p>
     * Use to get account level configuration.
     * </p>
     *
     * @param getAccountConfigurationRequest
     * @return Result of the GetAccountConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountConfigurationResponse getAccountConfiguration(GetAccountConfigurationRequest getAccountConfigurationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to get account level configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetAccountConfigurationRequest#builder()}
     * </p>
     *
     * @param getAccountConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountConfigurationResponse getAccountConfiguration(
            Consumer<GetAccountConfigurationRequest.Builder> getAccountConfigurationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CodeGuruSecurityException {
        return getAccountConfiguration(GetAccountConfigurationRequest.builder().applyMutation(getAccountConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all findings generated by a particular scan.
     * </p>
     *
     * @param getFindingsRequest
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all findings generated by a particular scan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingsResponse getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all findings generated by a particular scan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFindings(software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable responses = client
     *             .getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @param getFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator(GetFindingsRequest getFindingsRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return new GetFindingsIterable(this, getFindingsRequest);
    }

    /**
     * <p>
     * Returns a list of all findings generated by a particular scan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFindings(software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable responses = client
     *             .getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator(Consumer<GetFindingsRequest.Builder> getFindingsRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return getFindingsPaginator(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Returns top level metrics about an account from a specified date, including number of open findings, the
     * categories with most findings, the scans with most open findings, and scans with most open critical findings.
     * </p>
     *
     * @param getMetricsSummaryRequest
     * @return Result of the GetMetricsSummary operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetMetricsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetMetricsSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMetricsSummaryResponse getMetricsSummary(GetMetricsSummaryRequest getMetricsSummaryRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns top level metrics about an account from a specified date, including number of open findings, the
     * categories with most findings, the scans with most open findings, and scans with most open critical findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricsSummaryRequest.Builder} avoiding the need
     * to create one manually via {@link GetMetricsSummaryRequest#builder()}
     * </p>
     *
     * @param getMetricsSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetMetricsSummaryRequest.Builder} to create a request.
     * @return Result of the GetMetricsSummary operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetMetricsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetMetricsSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMetricsSummaryResponse getMetricsSummary(Consumer<GetMetricsSummaryRequest.Builder> getMetricsSummaryRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        return getMetricsSummary(GetMetricsSummaryRequest.builder().applyMutation(getMetricsSummaryRequest).build());
    }

    /**
     * <p>
     * Returns details about a scan, including whether or not a scan has completed.
     * </p>
     *
     * @param getScanRequest
     * @return Result of the GetScan operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetScan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetScanResponse getScan(GetScanRequest getScanRequest) throws InternalServerException, ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a scan, including whether or not a scan has completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScanRequest.Builder} avoiding the need to create
     * one manually via {@link GetScanRequest#builder()}
     * </p>
     *
     * @param getScanRequest
     *        A {@link Consumer} that will call methods on {@link GetScanRequest.Builder} to create a request.
     * @return Result of the GetScan operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.GetScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetScan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetScanResponse getScan(Consumer<GetScanRequest.Builder> getScanRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CodeGuruSecurityException {
        return getScan(GetScanRequest.builder().applyMutation(getScanRequest).build());
    }

    /**
     * <p>
     * Returns metrics about all findings in an account within a specified time range.
     * </p>
     *
     * @param listFindingsMetricsRequest
     * @return Result of the ListFindingsMetrics operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListFindingsMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListFindingsMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsMetricsResponse listFindingsMetrics(ListFindingsMetricsRequest listFindingsMetricsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metrics about all findings in an account within a specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingsMetricsRequest#builder()}
     * </p>
     *
     * @param listFindingsMetricsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsMetricsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFindingsMetrics operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListFindingsMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListFindingsMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsMetricsResponse listFindingsMetrics(
            Consumer<ListFindingsMetricsRequest.Builder> listFindingsMetricsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CodeGuruSecurityException {
        return listFindingsMetrics(ListFindingsMetricsRequest.builder().applyMutation(listFindingsMetricsRequest).build());
    }

    /**
     * <p>
     * Returns metrics about all findings in an account within a specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingsMetrics(software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable responses = client.listFindingsMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable responses = client
     *             .listFindingsMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable responses = client.listFindingsMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingsMetrics(software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingsMetricsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListFindingsMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListFindingsMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsMetricsIterable listFindingsMetricsPaginator(ListFindingsMetricsRequest listFindingsMetricsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        return new ListFindingsMetricsIterable(this, listFindingsMetricsRequest);
    }

    /**
     * <p>
     * Returns metrics about all findings in an account within a specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingsMetrics(software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable responses = client.listFindingsMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable responses = client
     *             .listFindingsMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable responses = client.listFindingsMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingsMetrics(software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingsMetricsRequest#builder()}
     * </p>
     *
     * @param listFindingsMetricsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsMetricsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListFindingsMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListFindingsMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsMetricsIterable listFindingsMetricsPaginator(
            Consumer<ListFindingsMetricsRequest.Builder> listFindingsMetricsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CodeGuruSecurityException {
        return listFindingsMetricsPaginator(ListFindingsMetricsRequest.builder().applyMutation(listFindingsMetricsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all the standard scans in an account. Does not return express scans.
     * </p>
     *
     * @param listScansRequest
     * @return Result of the ListScans operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListScans" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScansResponse listScans(ListScansRequest listScansRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the standard scans in an account. Does not return express scans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScansRequest.Builder} avoiding the need to
     * create one manually via {@link ListScansRequest#builder()}
     * </p>
     *
     * @param listScansRequest
     *        A {@link Consumer} that will call methods on {@link ListScansRequest.Builder} to create a request.
     * @return Result of the ListScans operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListScans" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScansResponse listScans(Consumer<ListScansRequest.Builder> listScansRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CodeGuruSecurityException {
        return listScans(ListScansRequest.builder().applyMutation(listScansRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the standard scans in an account. Does not return express scans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listScans(software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable responses = client.listScansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable responses = client.listScansPaginator(request);
     *     for (software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable responses = client.listScansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScans(software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest)} operation.</b>
     * </p>
     *
     * @param listScansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListScans" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScansIterable listScansPaginator(ListScansRequest listScansRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            CodeGuruSecurityException {
        return new ListScansIterable(this, listScansRequest);
    }

    /**
     * <p>
     * Returns a list of all the standard scans in an account. Does not return express scans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listScans(software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable responses = client.listScansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable responses = client.listScansPaginator(request);
     *     for (software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable responses = client.listScansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScans(software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScansRequest.Builder} avoiding the need to
     * create one manually via {@link ListScansRequest#builder()}
     * </p>
     *
     * @param listScansRequest
     *        A {@link Consumer} that will call methods on {@link ListScansRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListScans" target="_top">AWS
     *      API Documentation</a>
     */
    default ListScansIterable listScansPaginator(Consumer<ListScansRequest.Builder> listScansRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        return listScansPaginator(ListScansRequest.builder().applyMutation(listScansRequest).build());
    }

    /**
     * <p>
     * Returns a list of all tags associated with a scan.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all tags associated with a scan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Use to add one or more tags to an existing scan.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to add one or more tags to an existing scan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Use to remove one or more tags from an existing scan.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to remove one or more tags from an existing scan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Use to update account-level configuration with an encryption key.
     * </p>
     *
     * @param updateAccountConfigurationRequest
     * @return Result of the UpdateAccountConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountConfigurationResponse updateAccountConfiguration(
            UpdateAccountConfigurationRequest updateAccountConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to update account-level configuration with an encryption key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAccountConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAccountConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ResourceNotFoundException
     *         The resource specified in the request was not found.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruSecurityException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruSecurityClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountConfigurationResponse updateAccountConfiguration(
            Consumer<UpdateAccountConfigurationRequest.Builder> updateAccountConfigurationRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return updateAccountConfiguration(UpdateAccountConfigurationRequest.builder()
                .applyMutation(updateAccountConfigurationRequest).build());
    }

    /**
     * Create a {@link CodeGuruSecurityClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeGuruSecurityClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeGuruSecurityClient}.
     */
    static CodeGuruSecurityClientBuilder builder() {
        return new DefaultCodeGuruSecurityClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CodeGuruSecurityServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
