/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerAsyncClient;
import software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary;

public class ListRepositoryAssociationsPublisher
implements SdkPublisher<ListRepositoryAssociationsResponse> {
    private final CodeGuruReviewerAsyncClient client;
    private final ListRepositoryAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRepositoryAssociationsPublisher(CodeGuruReviewerAsyncClient client, ListRepositoryAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRepositoryAssociationsPublisher(CodeGuruReviewerAsyncClient client, ListRepositoryAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRepositoryAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRepositoryAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RepositoryAssociationSummary> repositoryAssociationSummaries() {
        Function<ListRepositoryAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositoryAssociationSummaries() != null) {
                return response.repositoryAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRepositoryAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRepositoryAssociationsResponseFetcher
    implements AsyncPageFetcher<ListRepositoryAssociationsResponse> {
        private ListRepositoryAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoryAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRepositoryAssociationsResponse> nextPage(ListRepositoryAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoryAssociationsPublisher.this.client.listRepositoryAssociations(ListRepositoryAssociationsPublisher.this.firstRequest);
            }
            return ListRepositoryAssociationsPublisher.this.client.listRepositoryAssociations((ListRepositoryAssociationsRequest)((Object)ListRepositoryAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

