/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a frame metric and its values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameMetricDatum implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameMetricDatum.Builder, FrameMetricDatum> {
    private static final SdkField<FrameMetric> FRAME_METRIC_FIELD = SdkField.<FrameMetric> builder(MarshallingType.SDK_POJO)
            .memberName("frameMetric").getter(getter(FrameMetricDatum::frameMetric)).setter(setter(Builder::frameMetric))
            .constructor(FrameMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameMetric").build()).build();

    private static final SdkField<List<Double>> VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(FrameMetricDatum::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_METRIC_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final FrameMetric frameMetric;

    private final List<Double> values;

    private FrameMetricDatum(BuilderImpl builder) {
        this.frameMetric = builder.frameMetric;
        this.values = builder.values;
    }

    /**
     * Returns the value of the FrameMetric property for this object.
     * 
     * @return The value of the FrameMetric property for this object.
     */
    public final FrameMetric frameMetric() {
        return frameMetric;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values that are associated with a frame metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of values that are associated with a frame metric.
     */
    public final List<Double> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frameMetric());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameMetricDatum)) {
            return false;
        }
        FrameMetricDatum other = (FrameMetricDatum) obj;
        return Objects.equals(frameMetric(), other.frameMetric()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameMetricDatum").add("FrameMetric", frameMetric())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frameMetric":
            return Optional.ofNullable(clazz.cast(frameMetric()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameMetricDatum, T> g) {
        return obj -> g.apply((FrameMetricDatum) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameMetricDatum> {
        /**
         * Sets the value of the FrameMetric property for this object.
         *
         * @param frameMetric
         *        The new value for the FrameMetric property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameMetric(FrameMetric frameMetric);

        /**
         * Sets the value of the FrameMetric property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FrameMetric.Builder} avoiding the need to
         * create one manually via {@link FrameMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FrameMetric.Builder#build()} is called immediately and its result
         * is passed to {@link #frameMetric(FrameMetric)}.
         * 
         * @param frameMetric
         *        a consumer that will call methods on {@link FrameMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameMetric(FrameMetric)
         */
        default Builder frameMetric(Consumer<FrameMetric.Builder> frameMetric) {
            return frameMetric(FrameMetric.builder().applyMutation(frameMetric).build());
        }

        /**
         * <p>
         * A list of values that are associated with a frame metric.
         * </p>
         * 
         * @param values
         *        A list of values that are associated with a frame metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<Double> values);

        /**
         * <p>
         * A list of values that are associated with a frame metric.
         * </p>
         * 
         * @param values
         *        A list of values that are associated with a frame metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Double... values);
    }

    static final class BuilderImpl implements Builder {
        private FrameMetric frameMetric;

        private List<Double> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FrameMetricDatum model) {
            frameMetric(model.frameMetric);
            values(model.values);
        }

        public final FrameMetric.Builder getFrameMetric() {
            return frameMetric != null ? frameMetric.toBuilder() : null;
        }

        public final void setFrameMetric(FrameMetric.BuilderImpl frameMetric) {
            this.frameMetric = frameMetric != null ? frameMetric.build() : null;
        }

        @Override
        public final Builder frameMetric(FrameMetric frameMetric) {
            this.frameMetric = frameMetric;
            return this;
        }

        public final Collection<Double> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<Double> values) {
            this.values = FrameMetricValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = FrameMetricValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public FrameMetricDatum build() {
            return new FrameMetricDatum(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
