/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient;
import software.amazon.awssdk.services.codeguruprofiler.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse;

public class GetFindingsReportAccountSummaryPublisher
implements SdkPublisher<GetFindingsReportAccountSummaryResponse> {
    private final CodeGuruProfilerAsyncClient client;
    private final GetFindingsReportAccountSummaryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingsReportAccountSummaryPublisher(CodeGuruProfilerAsyncClient client, GetFindingsReportAccountSummaryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingsReportAccountSummaryPublisher(CodeGuruProfilerAsyncClient client, GetFindingsReportAccountSummaryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingsReportAccountSummaryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingsReportAccountSummaryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetFindingsReportAccountSummaryResponseFetcher
    implements AsyncPageFetcher<GetFindingsReportAccountSummaryResponse> {
        private GetFindingsReportAccountSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsReportAccountSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingsReportAccountSummaryResponse> nextPage(GetFindingsReportAccountSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetFindingsReportAccountSummaryPublisher.this.client.getFindingsReportAccountSummary(GetFindingsReportAccountSummaryPublisher.this.firstRequest);
            }
            return GetFindingsReportAccountSummaryPublisher.this.client.getFindingsReportAccountSummary((GetFindingsReportAccountSummaryRequest)((Object)GetFindingsReportAccountSummaryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

