/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatedProfileTime
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatedProfileTime> {
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(AggregatedProfileTime.getter(AggregatedProfileTime::periodAsString)).setter(AggregatedProfileTime.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<Instant> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("start").getter(AggregatedProfileTime.getter(AggregatedProfileTime::start)).setter(AggregatedProfileTime.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_FIELD, START_FIELD));
    private static final long serialVersionUID = 1L;
    private final String period;
    private final Instant start;

    private AggregatedProfileTime(BuilderImpl builder) {
        this.period = builder.period;
        this.start = builder.start;
    }

    public final AggregationPeriod period() {
        return AggregationPeriod.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final Instant start() {
        return this.start;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedProfileTime)) {
            return false;
        }
        AggregatedProfileTime other = (AggregatedProfileTime)obj;
        return Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.start(), other.start());
    }

    public final String toString() {
        return ToString.builder((String)"AggregatedProfileTime").add("Period", (Object)this.periodAsString()).add("Start", (Object)this.start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedProfileTime, T> g) {
        return obj -> g.apply((AggregatedProfileTime)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String period;
        private Instant start;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedProfileTime model) {
            this.period(model.period);
            this.start(model.start);
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(AggregationPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final Instant getStart() {
            return this.start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public AggregatedProfileTime build() {
            return new AggregatedProfileTime(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatedProfileTime> {
        public Builder period(String var1);

        public Builder period(AggregationPeriod var1);

        public Builder start(Instant var1);
    }
}

