/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerServiceClientConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.DefaultCodeGuruProfilerAsyncClient;
import software.amazon.awssdk.services.codeguruprofiler.DefaultCodeGuruProfilerBaseClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.endpoints.CodeGuruProfilerEndpointProvider;

@SdkInternalApi
final class DefaultCodeGuruProfilerAsyncClientBuilder
extends DefaultCodeGuruProfilerBaseClientBuilder<CodeGuruProfilerAsyncClientBuilder, CodeGuruProfilerAsyncClient>
implements CodeGuruProfilerAsyncClientBuilder {
    DefaultCodeGuruProfilerAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeGuruProfilerAsyncClientBuilder endpointProvider(CodeGuruProfilerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeGuruProfilerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeGuruProfilerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeGuruProfilerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeGuruProfilerAsyncClient client = new DefaultCodeGuruProfilerAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeGuruProfilerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeGuruProfilerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

