/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.waiters;

import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import software.amazon.awssdk.codegen.jmespath.component.AndExpression;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifier;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifierWithContents;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifierWithQuestionMark;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifierWithoutContents;
import software.amazon.awssdk.codegen.jmespath.component.ComparatorExpression;
import software.amazon.awssdk.codegen.jmespath.component.CurrentNode;
import software.amazon.awssdk.codegen.jmespath.component.Expression;
import software.amazon.awssdk.codegen.jmespath.component.ExpressionType;
import software.amazon.awssdk.codegen.jmespath.component.FunctionArg;
import software.amazon.awssdk.codegen.jmespath.component.FunctionExpression;
import software.amazon.awssdk.codegen.jmespath.component.IndexExpression;
import software.amazon.awssdk.codegen.jmespath.component.Literal;
import software.amazon.awssdk.codegen.jmespath.component.MultiSelectHash;
import software.amazon.awssdk.codegen.jmespath.component.MultiSelectList;
import software.amazon.awssdk.codegen.jmespath.component.NotExpression;
import software.amazon.awssdk.codegen.jmespath.component.OrExpression;
import software.amazon.awssdk.codegen.jmespath.component.ParenExpression;
import software.amazon.awssdk.codegen.jmespath.component.PipeExpression;
import software.amazon.awssdk.codegen.jmespath.component.SliceExpression;
import software.amazon.awssdk.codegen.jmespath.component.SubExpression;
import software.amazon.awssdk.codegen.jmespath.component.SubExpressionRight;
import software.amazon.awssdk.codegen.jmespath.component.WildcardExpression;
import software.amazon.awssdk.codegen.jmespath.parser.JmesPathParser;
import software.amazon.awssdk.codegen.jmespath.parser.JmesPathVisitor;
import software.amazon.awssdk.utils.Validate;

public class JmesPathAcceptorGenerator {
    private final ClassName waitersRuntimeClass;

    public JmesPathAcceptorGenerator(ClassName waitersRuntimeClass) {
        this.waitersRuntimeClass = waitersRuntimeClass;
    }

    public CodeBlock interpret(String expression, String inputValue) {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        Visitor visitor = new Visitor(codeBlock, inputValue);
        JmesPathParser.parse(expression).visit(visitor);
        return visitor.codeBlock.build();
    }

    private class Visitor
    implements JmesPathVisitor {
        private final CodeBlock.Builder codeBlock;
        private final Deque<String> variables = new ArrayDeque<String>();
        private int variableIndex = 0;

        private Visitor(CodeBlock.Builder codeBlock, String inputValue) {
            this.codeBlock = codeBlock;
            this.codeBlock.add(inputValue, new Object[0]);
            this.variables.push(inputValue);
        }

        @Override
        public void visitExpression(Expression input) {
            input.visit(this);
        }

        @Override
        public void visitSubExpression(SubExpression input) {
            this.visitExpression(input.leftExpression());
            this.visitSubExpressionRight(input.rightSubExpression());
        }

        @Override
        public void visitSubExpressionRight(SubExpressionRight input) {
            input.visit(this);
        }

        @Override
        public void visitIndexExpression(IndexExpression input) {
            input.expression().ifPresent(this::visitExpression);
            this.visitBracketSpecifier(input.bracketSpecifier());
        }

        @Override
        public void visitBracketSpecifier(BracketSpecifier input) {
            input.visit(this);
        }

        @Override
        public void visitBracketSpecifierWithContents(BracketSpecifierWithContents input) {
            if (!input.isNumber()) {
                throw new UnsupportedOperationException();
            }
            this.codeBlock.add(".index(" + input.asNumber() + ")", new Object[0]);
        }

        @Override
        public void visitBracketSpecifierWithoutContents(BracketSpecifierWithoutContents input) {
            this.codeBlock.add(".flatten()", new Object[0]);
        }

        @Override
        public void visitBracketSpecifierWithQuestionMark(BracketSpecifierWithQuestionMark input) {
            this.pushVariable();
            this.codeBlock.add(".filter($1N -> $1N", new Object[]{this.currentVariable()});
            this.visitExpression(input.expression());
            this.codeBlock.add(")", new Object[0]);
            this.popVariable();
        }

        @Override
        public void visitSliceExpression(SliceExpression input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitComparatorExpression(ComparatorExpression input) {
            this.visitExpression(input.leftExpression());
            this.codeBlock.add(".compare($S, $N", new Object[]{input.comparator().tokenSymbol(), this.currentVariable()});
            this.visitExpression(input.rightExpression());
            this.codeBlock.add(")", new Object[0]);
        }

        @Override
        public void visitOrExpression(OrExpression input) {
            this.visitExpression(input.leftExpression());
            this.codeBlock.add(".or($N", new Object[]{this.currentVariable()});
            this.visitExpression(input.rightExpression());
            this.codeBlock.add(")", new Object[0]);
        }

        @Override
        public void visitAndExpression(AndExpression input) {
            this.visitExpression(input.leftExpression());
            this.codeBlock.add(".and($N", new Object[]{this.currentVariable()});
            this.visitExpression(input.rightExpression());
            this.codeBlock.add(")", new Object[0]);
        }

        @Override
        public void visitNotExpression(NotExpression input) {
            this.codeBlock.add(".constant($N", new Object[]{this.currentVariable()});
            this.visitExpression(input.expression());
            this.codeBlock.add(".not())", new Object[0]);
        }

        @Override
        public void visitParenExpression(ParenExpression input) {
            this.visitExpression(input.expression());
        }

        @Override
        public void visitWildcardExpression(WildcardExpression input) {
            this.codeBlock.add(".wildcard()", new Object[0]);
        }

        @Override
        public void visitMultiSelectList(MultiSelectList input) {
            this.codeBlock.add(".multiSelectList(", new Object[0]);
            boolean first = true;
            for (Expression expression : input.expressions()) {
                if (!first) {
                    this.codeBlock.add(", ", new Object[0]);
                } else {
                    first = false;
                }
                this.pushVariable();
                this.codeBlock.add("$1N -> $1N", new Object[]{this.currentVariable()});
                this.visitExpression(expression);
                this.popVariable();
            }
            this.codeBlock.add(")", new Object[0]);
        }

        @Override
        public void visitMultiSelectHash(MultiSelectHash input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitExpressionType(ExpressionType asExpressionType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitFunctionExpression(FunctionExpression input) {
            switch (input.function()) {
                case "length": {
                    this.visitLengthFunction(input.functionArgs());
                    break;
                }
                case "contains": {
                    this.visitContainsFunction(input.functionArgs());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported function: " + input.function());
                }
            }
        }

        private void visitLengthFunction(List<FunctionArg> functionArgs) {
            Validate.isTrue((functionArgs.size() == 1 ? 1 : 0) != 0, (String)"length function only supports 1 parameter.", (Object[])new Object[0]);
            Validate.isTrue((boolean)functionArgs.get(0).isExpression(), (String)"length's first parameter must be an expression.", (Object[])new Object[0]);
            this.visitExpression(functionArgs.get(0).asExpression());
            this.codeBlock.add(".length()", new Object[0]);
        }

        private void visitContainsFunction(List<FunctionArg> functionArgs) {
            Validate.isTrue((functionArgs.size() == 2 ? 1 : 0) != 0, (String)"contains function only supports 2 parameter.", (Object[])new Object[0]);
            Validate.isTrue((boolean)functionArgs.get(0).isExpression(), (String)"contain's first parameter must be an expression.", (Object[])new Object[0]);
            Validate.isTrue((boolean)functionArgs.get(1).isExpression(), (String)"contain's second parameter must be an expression.", (Object[])new Object[0]);
            this.visitExpression(functionArgs.get(0).asExpression());
            this.codeBlock.add(".contains($N", new Object[]{this.currentVariable()});
            this.visitExpression(functionArgs.get(1).asExpression());
            this.codeBlock.add(")", new Object[0]);
        }

        @Override
        public void visitPipeExpression(PipeExpression input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitCurrentNode(CurrentNode input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitRawString(String input) {
            this.codeBlock.add(".constant($S)", new Object[]{input});
        }

        @Override
        public void visitLiteral(Literal input) {
            JrsValue jsonValue = input.jsonValue();
            if (jsonValue.isNumber()) {
                this.codeBlock.add(".constant($L)", new Object[]{Integer.parseInt(jsonValue.asText())});
            } else if (jsonValue instanceof JrsBoolean) {
                this.codeBlock.add(".constant($L)", new Object[]{((JrsBoolean)jsonValue).booleanValue()});
            } else {
                throw new IllegalArgumentException("Unsupported JSON node type: " + input.jsonValue().getClass().getSimpleName());
            }
        }

        @Override
        public void visitIdentifier(String input) {
            this.codeBlock.add(".field($S)", new Object[]{input});
        }

        @Override
        public void visitNumber(int input) {
            this.codeBlock.add(".constant($L)", new Object[]{JmesPathAcceptorGenerator.this.waitersRuntimeClass.nestedClass("Value"), input});
        }

        public void pushVariable() {
            this.variables.push("x" + this.variableIndex++);
        }

        public String currentVariable() {
            return this.variables.getFirst();
        }

        public void popVariable() {
            this.variables.pop();
        }
    }
}

