/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.auth.signer.SignerLoader;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.util.SignerOverrideUtils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.endpoints.Endpoint;

public class EndpointAuthSchemeInterceptorClassSpec
implements ClassSpec {
    private static final String SIGV4_NAME = "sigv4";
    private static final String SIGV4A_NAME = "sigv4a";
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointAuthSchemeInterceptorClassSpec(IntermediateModel intermediateModel) {
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface(ExecutionInterceptor.class);
        b.addMethod(this.modifyRequestMethod());
        b.addMethod(this.signerProviderMethod());
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.authSchemesInterceptorName();
    }

    private MethodSpec modifyRequestMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"modifyRequest").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)ClassName.get(Context.ModifyRequest.class), "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]).returns(SdkRequest.class);
        builder.addStatement("$T resolvedEndpoint = executionAttributes.getAttribute($T.RESOLVED_ENDPOINT)", new Object[]{Endpoint.class, SdkInternalExecutionAttribute.class});
        builder.addStatement("$1T request = ($1T) context.request()", new Object[]{AwsRequest.class});
        builder.beginControlFlow("if (resolvedEndpoint.headers() != null)", new Object[0]).addStatement("request = $T.addHeaders(request, resolvedEndpoint.headers())", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")});
        builder.endControlFlow();
        builder.addStatement("$T authSchemes = resolvedEndpoint.attribute($T.AUTH_SCHEMES)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{EndpointAuthScheme.class}), AwsEndpointAttribute.class});
        builder.beginControlFlow("if (authSchemes == null)", new Object[0]).addStatement("return request", new Object[0]).endControlFlow();
        builder.addStatement("$T chosenAuthScheme = $T.chooseAuthScheme(authSchemes)", new Object[]{EndpointAuthScheme.class, this.endpointRulesSpecUtils.rulesRuntimeClassName("AuthSchemeUtils")});
        builder.addStatement("$T signerProvider = signerProvider(chosenAuthScheme)", new Object[]{ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{Signer.class})});
        builder.addStatement("$T.setSigningParams(executionAttributes, chosenAuthScheme)", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AuthSchemeUtils")});
        builder.addStatement("return $T.overrideSignerIfNotOverridden(request, executionAttributes, signerProvider)", new Object[]{SignerOverrideUtils.class});
        return builder.build();
    }

    private MethodSpec signerProviderMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"signerProvider").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(EndpointAuthScheme.class, "authScheme", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{Signer.class}));
        builder.beginControlFlow("switch (authScheme.name())", new Object[0]);
        builder.addCode("case $S:", new Object[]{SIGV4_NAME});
        if (this.endpointRulesSpecUtils.isS3() || this.endpointRulesSpecUtils.isS3Control()) {
            builder.addStatement("return $T::create", new Object[]{AwsS3V4Signer.class});
        } else {
            builder.addStatement("return $T::create", new Object[]{Aws4Signer.class});
        }
        builder.addCode("case $S:", new Object[]{SIGV4A_NAME});
        if (this.endpointRulesSpecUtils.isS3() || this.endpointRulesSpecUtils.isS3Control()) {
            builder.addStatement("return $T::getS3SigV4aSigner", new Object[]{SignerLoader.class});
        } else {
            builder.addStatement("return $T::getSigV4aSigner", new Object[]{SignerLoader.class});
        }
        builder.addCode("default:", new Object[0]);
        builder.addStatement("break", new Object[0]);
        builder.endControlFlow();
        builder.addStatement("throw $T.create($S + authScheme.name())", new Object[]{SdkClientException.class, "Don't know how to create signer for auth scheme: "});
        return builder.build();
    }
}

