/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.regions.Region;

public class ClientSimpleMethodsIntegrationTests
implements ClassSpec {
    private final IntermediateModel model;
    private final PoetExtension poetExtensions;

    public ClientSimpleMethodsIntegrationTests(IntermediateModel model) {
        this.model = model;
        this.poetExtensions = new PoetExtension(model);
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(FieldSpec.builder((TypeName)interfaceClass, (String)"client", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build()).addMethod(this.setup());
        this.model.simpleMethodsRequiringTesting().stream().map(this::simpleMethodsTest).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        return builder.build();
    }

    @Override
    public ClassName className() {
        return this.poetExtensions.getClientClass("SimpleMethodsIntegrationTest");
    }

    private MethodSpec setup() {
        String defaultRegion = Optional.ofNullable(this.model.getCustomizationConfig().getDefaultSimpleMethodTestRegion()).orElse("US_EAST_1");
        ClassName beforeClass = ClassName.get((String)"org.junit", (String)"BeforeClass", (String[])new String[0]);
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        return MethodSpec.methodBuilder((String)"setup").addAnnotation(beforeClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).beginControlFlow("if ($T.serviceMetadata().regions().isEmpty())", new Object[]{interfaceClass}).addStatement("client = $T.builder().region($T.$L).build()", new Object[]{interfaceClass, Region.class, defaultRegion}).endControlFlow().beginControlFlow("else if ($T.serviceMetadata().regions().contains($T.AWS_GLOBAL))", new Object[]{interfaceClass, Region.class}).addStatement("client = $T.builder().region($T.AWS_GLOBAL).build()", new Object[]{interfaceClass, Region.class}).endControlFlow().beginControlFlow("else if ($T.serviceMetadata().regions().contains($T.US_EAST_1))", new Object[]{interfaceClass, Region.class}).addStatement("client = $T.builder().region($T.US_EAST_1).build()", new Object[]{interfaceClass, Region.class}).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("client = $1T.builder().region($1T.serviceMetadata().regions().get(0)).build()", new Object[]{interfaceClass}).endControlFlow().build();
    }

    private MethodSpec simpleMethodsTest(OperationModel opModel) {
        ClassName testClass = ClassName.get((String)"org.junit", (String)"Test", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)(opModel.getMethodName() + "_SimpleMethod_Succeeds")).addAnnotation(testClass).addException(Exception.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("client.$N()", new Object[]{opModel.getMethodName()}).build();
    }
}

