/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.poet.builder.AsyncClientBuilderClass;
import software.amazon.awssdk.codegen.poet.builder.AsyncClientBuilderInterface;
import software.amazon.awssdk.codegen.poet.client.AsyncClientClass;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.DelegatingAsyncClientClass;
import software.amazon.awssdk.codegen.poet.endpointdiscovery.EndpointDiscoveryAsyncCacheLoaderGenerator;

public class AsyncClientGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public AsyncClientGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> generatorTasks = new ArrayList<GeneratorTask>();
        generatorTasks.add(this.createClientClassTask());
        generatorTasks.add(this.createClientBuilderTask());
        generatorTasks.add(this.createClientBuilderInterfaceTask());
        generatorTasks.add(this.createClientInterfaceTask());
        if (this.model.getEndpointOperation().isPresent()) {
            generatorTasks.add(this.createEndpointDiscoveryCacheLoaderTask());
        }
        if (this.model.getCustomizationConfig().isDelegateAsyncClientClass()) {
            generatorTasks.add(this.createDecoratorClientClassTask());
        }
        return generatorTasks;
    }

    private GeneratorTask createClientClassTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientClass(this.generatorTaskParams));
    }

    private GeneratorTask createDecoratorClientClassTask() throws IOException {
        return this.createPoetGeneratorTask(new DelegatingAsyncClientClass(this.model));
    }

    private GeneratorTask createClientBuilderTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientBuilderClass(this.model));
    }

    private GeneratorTask createClientBuilderInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientBuilderInterface(this.model));
    }

    private GeneratorTask createClientInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new AsyncClientInterface(this.model));
    }

    private GeneratorTask createEndpointDiscoveryCacheLoaderTask() throws IOException {
        return this.createPoetGeneratorTask(new EndpointDiscoveryAsyncCacheLoaderGenerator(this.generatorTaskParams));
    }
}

