/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import software.amazon.awssdk.codegen.docs.AsyncOperationDocProvider;
import software.amazon.awssdk.codegen.docs.DocConfiguration;
import software.amazon.awssdk.codegen.docs.Factory;
import software.amazon.awssdk.codegen.docs.OperationDocProvider;
import software.amazon.awssdk.codegen.docs.SyncOperationDocProvider;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;

public enum SimpleMethodOverload {
    NORMAL(SyncOperationDocProvider::new, AsyncOperationDocProvider::new),
    PAGINATED(SyncOperationDocProvider.SyncPaginated::new, AsyncOperationDocProvider.AsyncPaginated::new),
    NO_ARG(SyncOperationDocProvider.SyncNoArg::new, AsyncOperationDocProvider.AsyncNoArg::new),
    NO_ARG_PAGINATED(SyncOperationDocProvider.SyncPaginatedNoArg::new, AsyncOperationDocProvider.AsyncPaginatedNoArg::new),
    FILE(SyncOperationDocProvider.SyncFile::new, AsyncOperationDocProvider.AsyncFile::new),
    INPUT_STREAM(SyncOperationDocProvider.SyncInputStream::new, null),
    BYTES(SyncOperationDocProvider.SyncBytes::new, null);

    private final Factory syncDocsFactory;
    private final Factory asyncDocsFactory;

    private SimpleMethodOverload(Factory syncDocsFactory, Factory asyncDocsFactory) {
        this.syncDocsFactory = syncDocsFactory;
        this.asyncDocsFactory = asyncDocsFactory;
    }

    public OperationDocProvider syncDocsProvider(IntermediateModel model, OperationModel opModel, DocConfiguration docConfiguration) {
        if (this.syncDocsFactory == null) {
            throw new UnsupportedOperationException((Object)((Object)this) + " is not currently documented for sync clients.");
        }
        return this.syncDocsFactory.create(model, opModel, docConfiguration);
    }

    public OperationDocProvider asyncDocsProvider(IntermediateModel model, OperationModel opModel, DocConfiguration docConfiguration) {
        if (this.asyncDocsFactory == null) {
            throw new UnsupportedOperationException((Object)((Object)this) + " is not currently documented for async clients.");
        }
        return this.asyncDocsFactory.create(model, opModel, docConfiguration);
    }
}

