/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.model.Partitions;
import software.amazon.awssdk.utils.ImmutableMap;

public class ServiceMetadataProviderGenerator
implements PoetClass {
    private final Partitions partitions;
    private final String basePackage;
    private final String regionBasePackage;

    public ServiceMetadataProviderGenerator(Partitions partitions, String basePackage, String regionBasePackage) {
        this.partitions = partitions;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
    }

    @Override
    public TypeSpec poetClass() {
        ParameterizedTypeName mapOfServiceMetadata = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get((String)this.regionBasePackage, (String)"ServiceMetadata", (String[])new String[0])});
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"ServiceMetadataProvider", (String[])new String[0])).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addAnnotation(SdkPublicApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addField(FieldSpec.builder((TypeName)mapOfServiceMetadata, (String)"SERVICE_METADATA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.regions(this.partitions)).build()).addMethod(this.getter()).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.regionBasePackage, (String)"GeneratedServiceMetadataProvider", (String[])new String[0]);
    }

    private CodeBlock regions(Partitions partitions) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<String, ServiceMetadata>builder()", new Object[]{ImmutableMap.class});
        HashSet seenServices = new HashSet();
        partitions.getPartitions().forEach(p -> p.getServices().keySet().forEach(s -> {
            if (!seenServices.contains(s)) {
                builder.add(".put($S, new $T())", new Object[]{s, this.serviceMetadataClass((String)s)});
                seenServices.add(s);
            }
        }));
        return builder.add(".build()", new Object[0]).build();
    }

    private ClassName serviceMetadataClass(String service) {
        if ("s3".equals(service)) {
            return ClassName.get((String)this.basePackage, (String)"EnhancedS3ServiceMetadata", (String[])new String[0]);
        }
        String sanitizedServiceName = service.replace(".", "-");
        return ClassName.get((String)this.basePackage, (String)(Stream.of(sanitizedServiceName.split("-")).map(Utils::capitalize).collect(Collectors.joining()) + "ServiceMetadata"), (String[])new String[0]);
    }

    private MethodSpec getter() {
        return MethodSpec.methodBuilder((String)"serviceMetadata").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "endpointPrefix", new Modifier[0]).returns((TypeName)ClassName.get((String)this.regionBasePackage, (String)"ServiceMetadata", (String[])new String[0])).addStatement("return $L.get($L)", new Object[]{"SERVICE_METADATA", "endpointPrefix"}).build();
    }
}

