/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.model.Partitions;
import software.amazon.awssdk.utils.ImmutableMap;

public class PartitionMetadataProviderGenerator
implements PoetClass {
    private final Partitions partitions;
    private final String basePackage;
    private final String regionBasePackage;

    public PartitionMetadataProviderGenerator(Partitions partitions, String basePackage, String regionBasePackage) {
        this.partitions = partitions;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
    }

    @Override
    public TypeSpec poetClass() {
        ParameterizedTypeName mapOfPartitionMetadata = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get((String)this.regionBasePackage, (String)"PartitionMetadata", (String[])new String[0])});
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"PartitionMetadataProvider", (String[])new String[0])).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addAnnotation(SdkPublicApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addField(FieldSpec.builder((TypeName)mapOfPartitionMetadata, (String)"PARTITION_METADATA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.partitions(this.partitions)).build()).addMethod(this.getter()).addMethod(this.partitionMetadata()).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.regionBasePackage, (String)"GeneratedPartitionMetadataProvider", (String[])new String[0]);
    }

    private CodeBlock partitions(Partitions partitions) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<String, PartitionMetadata>builder()", new Object[]{ImmutableMap.class});
        partitions.getPartitions().forEach(p -> builder.add(".put($S, new $T())", new Object[]{p.getPartition(), this.partitionMetadataClass(p.getPartition())}));
        return builder.add(".build()", new Object[0]).build();
    }

    private ClassName partitionMetadataClass(String partition) {
        return ClassName.get((String)this.basePackage, (String)(Stream.of(partition.split("-")).map(Utils::capitalize).collect(Collectors.joining()) + "PartitionMetadata"), (String[])new String[0]);
    }

    private MethodSpec partitionMetadata() {
        return MethodSpec.methodBuilder((String)"partitionMetadata").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]), "region", new Modifier[0]).returns((TypeName)ClassName.get((String)this.regionBasePackage, (String)"PartitionMetadata", (String[])new String[0])).addStatement("return $L.values().stream().filter(p -> $L.id().matches(p.regionRegex())).findFirst().orElse(new $L())", new Object[]{"PARTITION_METADATA", "region", "AwsPartitionMetadata"}).build();
    }

    private MethodSpec getter() {
        return MethodSpec.methodBuilder((String)"partitionMetadata").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "partition", new Modifier[0]).returns((TypeName)ClassName.get((String)this.regionBasePackage, (String)"PartitionMetadata", (String[])new String[0])).addStatement("return $L.get($L)", new Object[]{"PARTITION_METADATA", "partition"}).build();
    }
}

