/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;

public final class Utils {
    private Utils() {
    }

    public static String capitalize(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return name.length() < 2 ? StringUtils.upperCase((String)name) : StringUtils.upperCase((String)name.substring(0, 1)) + name.substring(1);
    }

    public static File createDirectory(String path) {
        if (Utils.isNullOrEmpty(path)) {
            throw new IllegalArgumentException("Invalid path directory. Path directory cannot be null or empty");
        }
        File dir = new File(path);
        Utils.createDirectory(dir);
        return dir;
    }

    public static void createDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Not able to create directory. " + dir.getAbsolutePath());
        }
    }

    public static File createFile(String dir, String fileName) throws IOException {
        if (Utils.isNullOrEmpty(fileName)) {
            throw new IllegalArgumentException("Invalid file name. File name cannot be null or empty");
        }
        Utils.createDirectory(dir);
        File file = new File(dir, fileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new RuntimeException("Not able to create file . " + file.getAbsolutePath());
        }
        return file;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static void closeQuietly(Closeable closeable) {
        IoUtils.closeQuietly((AutoCloseable)closeable, null);
    }
}

