/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LifecycleEventStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    SKIPPED("Skipped"),
    UNKNOWN("Unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LifecycleEventStatus> VALUE_MAP;
    private final String value;

    private LifecycleEventStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LifecycleEventStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LifecycleEventStatus> knownValues() {
        EnumSet<LifecycleEventStatus> knownValues = EnumSet.allOf(LifecycleEventStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LifecycleEventStatus.class, LifecycleEventStatus::toString);
    }
}

