/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoRollbackEvent {
    DEPLOYMENT_FAILURE("DEPLOYMENT_FAILURE"),
    DEPLOYMENT_STOP_ON_ALARM("DEPLOYMENT_STOP_ON_ALARM"),
    DEPLOYMENT_STOP_ON_REQUEST("DEPLOYMENT_STOP_ON_REQUEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoRollbackEvent> VALUE_MAP;
    private final String value;

    private AutoRollbackEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoRollbackEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoRollbackEvent> knownValues() {
        EnumSet<AutoRollbackEvent> knownValues = EnumSet.allOf(AutoRollbackEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoRollbackEvent.class, AutoRollbackEvent::toString);
    }
}

