/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse;

public class ListSharedProjectsIterable
implements SdkIterable<ListSharedProjectsResponse> {
    private final CodeBuildClient client;
    private final ListSharedProjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSharedProjectsIterable(CodeBuildClient client, ListSharedProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSharedProjectsResponseFetcher();
    }

    public Iterator<ListSharedProjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> projects() {
        Function<ListSharedProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projects() != null) {
                return response.projects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSharedProjectsResponseFetcher
    implements SyncPageFetcher<ListSharedProjectsResponse> {
        private ListSharedProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListSharedProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSharedProjectsResponse nextPage(ListSharedProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListSharedProjectsIterable.this.client.listSharedProjects(ListSharedProjectsIterable.this.firstRequest);
            }
            return ListSharedProjectsIterable.this.client.listSharedProjects((ListSharedProjectsRequest)((Object)ListSharedProjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

