/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse;

public class ListReportsForReportGroupPublisher
implements SdkPublisher<ListReportsForReportGroupResponse> {
    private final CodeBuildAsyncClient client;
    private final ListReportsForReportGroupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReportsForReportGroupPublisher(CodeBuildAsyncClient client, ListReportsForReportGroupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReportsForReportGroupPublisher(CodeBuildAsyncClient client, ListReportsForReportGroupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReportsForReportGroupResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReportsForReportGroupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> reports() {
        Function<ListReportsForReportGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.reports() != null) {
                return response.reports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReportsForReportGroupResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReportsForReportGroupResponseFetcher
    implements AsyncPageFetcher<ListReportsForReportGroupResponse> {
        private ListReportsForReportGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListReportsForReportGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReportsForReportGroupResponse> nextPage(ListReportsForReportGroupResponse previousPage) {
            if (previousPage == null) {
                return ListReportsForReportGroupPublisher.this.client.listReportsForReportGroup(ListReportsForReportGroupPublisher.this.firstRequest);
            }
            return ListReportsForReportGroupPublisher.this.client.listReportsForReportGroup((ListReportsForReportGroupRequest)((Object)ListReportsForReportGroupPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

