/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you
 * add one or more repositories.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainDescription.Builder, DomainDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DomainDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(DomainDescription::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DomainDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DomainDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(DomainDescription::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(DomainDescription::encryptionKey)).setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<Integer> REPOSITORY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("repositoryCount").getter(getter(DomainDescription::repositoryCount))
            .setter(setter(Builder::repositoryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCount").build()).build();

    private static final SdkField<Long> ASSET_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("assetSizeBytes").getter(getter(DomainDescription::assetSizeBytes))
            .setter(setter(Builder::assetSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetSizeBytes").build()).build();

    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketArn").getter(getter(DomainDescription::s3BucketArn)).setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OWNER_FIELD,
            ARN_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, ENCRYPTION_KEY_FIELD, REPOSITORY_COUNT_FIELD, ASSET_SIZE_BYTES_FIELD,
            S3_BUCKET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String owner;

    private final String arn;

    private final String status;

    private final Instant createdTime;

    private final String encryptionKey;

    private final Integer repositoryCount;

    private final Long assetSizeBytes;

    private final String s3BucketArn;

    private DomainDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.encryptionKey = builder.encryptionKey;
        this.repositoryCount = builder.repositoryCount;
        this.assetSizeBytes = builder.assetSizeBytes;
        this.s3BucketArn = builder.s3BucketArn;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the domain.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the domain.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the domain.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the domain.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of a domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of a domain.
     * @see DomainStatus
     */
    public final DomainStatus status() {
        return DomainStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of a domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of a domain.
     * @see DomainStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp that represents the date and time the domain was created.
     * </p>
     * 
     * @return A timestamp that represents the date and time the domain was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The ARN of an Key Management Service (KMS) key associated with a domain.
     * </p>
     * 
     * @return The ARN of an Key Management Service (KMS) key associated with a domain.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * The number of repositories in the domain.
     * </p>
     * 
     * @return The number of repositories in the domain.
     */
    public final Integer repositoryCount() {
        return repositoryCount;
    }

    /**
     * <p>
     * The total size of all assets in the domain.
     * </p>
     * 
     * @return The total size of all assets in the domain.
     */
    public final Long assetSizeBytes() {
        return assetSizeBytes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the
     *         domain.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryCount());
        hashCode = 31 * hashCode + Objects.hashCode(assetSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDescription)) {
            return false;
        }
        DomainDescription other = (DomainDescription) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(owner(), other.owner())
                && Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(encryptionKey(), other.encryptionKey())
                && Objects.equals(repositoryCount(), other.repositoryCount())
                && Objects.equals(assetSizeBytes(), other.assetSizeBytes()) && Objects.equals(s3BucketArn(), other.s3BucketArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainDescription").add("Name", name()).add("Owner", owner()).add("Arn", arn())
                .add("Status", statusAsString()).add("CreatedTime", createdTime()).add("EncryptionKey", encryptionKey())
                .add("RepositoryCount", repositoryCount()).add("AssetSizeBytes", assetSizeBytes())
                .add("S3BucketArn", s3BucketArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "repositoryCount":
            return Optional.ofNullable(clazz.cast(repositoryCount()));
        case "assetSizeBytes":
            return Optional.ofNullable(clazz.cast(assetSizeBytes()));
        case "s3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainDescription, T> g) {
        return obj -> g.apply((DomainDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainDescription> {
        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param name
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the domain.
         * </p>
         * 
         * @param owner
         *        The Amazon Web Services account ID that owns the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the domain.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of a domain.
         * </p>
         * 
         * @param status
         *        The current status of a domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of a domain.
         * </p>
         * 
         * @param status
         *        The current status of a domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(DomainStatus status);

        /**
         * <p>
         * A timestamp that represents the date and time the domain was created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that represents the date and time the domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The ARN of an Key Management Service (KMS) key associated with a domain.
         * </p>
         * 
         * @param encryptionKey
         *        The ARN of an Key Management Service (KMS) key associated with a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * The number of repositories in the domain.
         * </p>
         * 
         * @param repositoryCount
         *        The number of repositories in the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCount(Integer repositoryCount);

        /**
         * <p>
         * The total size of all assets in the domain.
         * </p>
         * 
         * @param assetSizeBytes
         *        The total size of all assets in the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSizeBytes(Long assetSizeBytes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.
         * </p>
         * 
         * @param s3BucketArn
         *        The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String owner;

        private String arn;

        private String status;

        private Instant createdTime;

        private String encryptionKey;

        private Integer repositoryCount;

        private Long assetSizeBytes;

        private String s3BucketArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDescription model) {
            name(model.name);
            owner(model.owner);
            arn(model.arn);
            status(model.status);
            createdTime(model.createdTime);
            encryptionKey(model.encryptionKey);
            repositoryCount(model.repositoryCount);
            assetSizeBytes(model.assetSizeBytes);
            s3BucketArn(model.s3BucketArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Integer getRepositoryCount() {
            return repositoryCount;
        }

        public final void setRepositoryCount(Integer repositoryCount) {
            this.repositoryCount = repositoryCount;
        }

        @Override
        public final Builder repositoryCount(Integer repositoryCount) {
            this.repositoryCount = repositoryCount;
            return this;
        }

        public final Long getAssetSizeBytes() {
            return assetSizeBytes;
        }

        public final void setAssetSizeBytes(Long assetSizeBytes) {
            this.assetSizeBytes = assetSizeBytes;
        }

        @Override
        public final Builder assetSizeBytes(Long assetSizeBytes) {
            this.assetSizeBytes = assetSizeBytes;
            return this;
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        @Override
        public DomainDescription build() {
            return new DomainDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
