/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;

public class GetLogEventsIterable
implements SdkIterable<GetLogEventsResponse> {
    private final CloudWatchLogsClient client;
    private final GetLogEventsRequest firstRequest;

    public GetLogEventsIterable(CloudWatchLogsClient client, GetLogEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
    }

    public Iterator<GetLogEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher((SyncPageFetcher)new GetLogEventsResponseFetcher()).build();
    }

    public final SdkIterable<OutputLogEvent> events() {
        Function<GetLogEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetLogEventsResponseFetcher
    implements SyncPageFetcher<GetLogEventsResponse> {
        private Object lastToken;

        private GetLogEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetLogEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextForwardToken()) && !previousPage.nextForwardToken().equals(this.lastToken);
        }

        public GetLogEventsResponse nextPage(GetLogEventsResponse previousPage) {
            if (previousPage == null) {
                this.lastToken = null;
                return GetLogEventsIterable.this.client.getLogEvents(GetLogEventsIterable.this.firstRequest);
            }
            this.lastToken = previousPage.nextForwardToken();
            return GetLogEventsIterable.this.client.getLogEvents((GetLogEventsRequest)((Object)GetLogEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextForwardToken()).build()));
        }
    }
}

