/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsAdditionalStatisticsCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsIncludeMetricsCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricStreamStatisticsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricStreamStatisticsConfiguration> {
    private static final SdkField<List<MetricStreamStatisticsMetric>> INCLUDE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeMetrics").getter(MetricStreamStatisticsConfiguration.getter(MetricStreamStatisticsConfiguration::includeMetrics)).setter(MetricStreamStatisticsConfiguration.setter(Builder::includeMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricStreamStatisticsMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalStatistics").getter(MetricStreamStatisticsConfiguration.getter(MetricStreamStatisticsConfiguration::additionalStatistics)).setter(MetricStreamStatisticsConfiguration.setter(Builder::additionalStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_METRICS_FIELD, ADDITIONAL_STATISTICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<MetricStreamStatisticsMetric> includeMetrics;
    private final List<String> additionalStatistics;

    private MetricStreamStatisticsConfiguration(BuilderImpl builder) {
        this.includeMetrics = builder.includeMetrics;
        this.additionalStatistics = builder.additionalStatistics;
    }

    public final boolean hasIncludeMetrics() {
        return this.includeMetrics != null && !(this.includeMetrics instanceof SdkAutoConstructList);
    }

    public final List<MetricStreamStatisticsMetric> includeMetrics() {
        return this.includeMetrics;
    }

    public final boolean hasAdditionalStatistics() {
        return this.additionalStatistics != null && !(this.additionalStatistics instanceof SdkAutoConstructList);
    }

    public final List<String> additionalStatistics() {
        return this.additionalStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeMetrics() ? this.includeMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalStatistics() ? this.additionalStatistics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStreamStatisticsConfiguration)) {
            return false;
        }
        MetricStreamStatisticsConfiguration other = (MetricStreamStatisticsConfiguration)obj;
        return this.hasIncludeMetrics() == other.hasIncludeMetrics() && Objects.equals(this.includeMetrics(), other.includeMetrics()) && this.hasAdditionalStatistics() == other.hasAdditionalStatistics() && Objects.equals(this.additionalStatistics(), other.additionalStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"MetricStreamStatisticsConfiguration").add("IncludeMetrics", this.hasIncludeMetrics() ? this.includeMetrics() : null).add("AdditionalStatistics", this.hasAdditionalStatistics() ? this.additionalStatistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IncludeMetrics": {
                return Optional.ofNullable(clazz.cast(this.includeMetrics()));
            }
            case "AdditionalStatistics": {
                return Optional.ofNullable(clazz.cast(this.additionalStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricStreamStatisticsConfiguration, T> g) {
        return obj -> g.apply((MetricStreamStatisticsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MetricStreamStatisticsMetric> includeMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<String> additionalStatistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStreamStatisticsConfiguration model) {
            this.includeMetrics(model.includeMetrics);
            this.additionalStatistics(model.additionalStatistics);
        }

        public final List<MetricStreamStatisticsMetric.Builder> getIncludeMetrics() {
            List<MetricStreamStatisticsMetric.Builder> result = MetricStreamStatisticsIncludeMetricsCopier.copyToBuilder(this.includeMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludeMetrics(Collection<MetricStreamStatisticsMetric.BuilderImpl> includeMetrics) {
            this.includeMetrics = MetricStreamStatisticsIncludeMetricsCopier.copyFromBuilder(includeMetrics);
        }

        @Override
        public final Builder includeMetrics(Collection<MetricStreamStatisticsMetric> includeMetrics) {
            this.includeMetrics = MetricStreamStatisticsIncludeMetricsCopier.copy(includeMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeMetrics(MetricStreamStatisticsMetric ... includeMetrics) {
            this.includeMetrics(Arrays.asList(includeMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeMetrics(Consumer<MetricStreamStatisticsMetric.Builder> ... includeMetrics) {
            this.includeMetrics(Stream.of(includeMetrics).map(c -> (MetricStreamStatisticsMetric)((MetricStreamStatisticsMetric.Builder)MetricStreamStatisticsMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAdditionalStatistics() {
            if (this.additionalStatistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalStatistics;
        }

        public final void setAdditionalStatistics(Collection<String> additionalStatistics) {
            this.additionalStatistics = MetricStreamStatisticsAdditionalStatisticsCopier.copy(additionalStatistics);
        }

        @Override
        public final Builder additionalStatistics(Collection<String> additionalStatistics) {
            this.additionalStatistics = MetricStreamStatisticsAdditionalStatisticsCopier.copy(additionalStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalStatistics(String ... additionalStatistics) {
            this.additionalStatistics(Arrays.asList(additionalStatistics));
            return this;
        }

        public MetricStreamStatisticsConfiguration build() {
            return new MetricStreamStatisticsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricStreamStatisticsConfiguration> {
        public Builder includeMetrics(Collection<MetricStreamStatisticsMetric> var1);

        public Builder includeMetrics(MetricStreamStatisticsMetric ... var1);

        public Builder includeMetrics(Consumer<MetricStreamStatisticsMetric.Builder> ... var1);

        public Builder additionalStatistics(Collection<String> var1);

        public Builder additionalStatistics(String ... var1);
    }
}

