/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedRuleDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedRuleDescription> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(ManagedRuleDescription.getter(ManagedRuleDescription::templateName)).setter(ManagedRuleDescription.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(ManagedRuleDescription.getter(ManagedRuleDescription::resourceARN)).setter(ManagedRuleDescription.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<ManagedRuleState> RULE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleState").getter(ManagedRuleDescription.getter(ManagedRuleDescription::ruleState)).setter(ManagedRuleDescription.setter(Builder::ruleState)).constructor(ManagedRuleState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, RESOURCE_ARN_FIELD, RULE_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final String resourceARN;
    private final ManagedRuleState ruleState;

    private ManagedRuleDescription(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.resourceARN = builder.resourceARN;
        this.ruleState = builder.ruleState;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final ManagedRuleState ruleState() {
        return this.ruleState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleDescription)) {
            return false;
        }
        ManagedRuleDescription other = (ManagedRuleDescription)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.ruleState(), other.ruleState());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedRuleDescription").add("TemplateName", (Object)this.templateName()).add("ResourceARN", (Object)this.resourceARN()).add("RuleState", (Object)this.ruleState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "RuleState": {
                return Optional.ofNullable(clazz.cast(this.ruleState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedRuleDescription, T> g) {
        return obj -> g.apply((ManagedRuleDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String resourceARN;
        private ManagedRuleState ruleState;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedRuleDescription model) {
            this.templateName(model.templateName);
            this.resourceARN(model.resourceARN);
            this.ruleState(model.ruleState);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final ManagedRuleState.Builder getRuleState() {
            return this.ruleState != null ? this.ruleState.toBuilder() : null;
        }

        public final void setRuleState(ManagedRuleState.BuilderImpl ruleState) {
            this.ruleState = ruleState != null ? ruleState.build() : null;
        }

        @Override
        public final Builder ruleState(ManagedRuleState ruleState) {
            this.ruleState = ruleState;
            return this;
        }

        public ManagedRuleDescription build() {
            return new ManagedRuleDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedRuleDescription> {
        public Builder templateName(String var1);

        public Builder resourceARN(String var1);

        public Builder ruleState(ManagedRuleState var1);

        default public Builder ruleState(Consumer<ManagedRuleState.Builder> ruleState) {
            return this.ruleState((ManagedRuleState)((ManagedRuleState.Builder)ManagedRuleState.builder().applyMutation(ruleState)).build());
        }
    }
}

