/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the objects or data listed below if successful. Otherwise, returns an error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrailResponse extends CloudTrailResponse implements
        ToCopyableBuilder<CreateTrailResponse.Builder, CreateTrailResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateTrailResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(CreateTrailResponse::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(CreateTrailResponse::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<String> SNS_TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicName").getter(getter(CreateTrailResponse::snsTopicName)).setter(setter(Builder::snsTopicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicARN").getter(getter(CreateTrailResponse::snsTopicARN)).setter(setter(Builder::snsTopicARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicARN").build()).build();

    private static final SdkField<Boolean> INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeGlobalServiceEvents")
            .getter(getter(CreateTrailResponse::includeGlobalServiceEvents))
            .setter(setter(Builder::includeGlobalServiceEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGlobalServiceEvents").build())
            .build();

    private static final SdkField<Boolean> IS_MULTI_REGION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsMultiRegionTrail").getter(getter(CreateTrailResponse::isMultiRegionTrail))
            .setter(setter(Builder::isMultiRegionTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMultiRegionTrail").build())
            .build();

    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailARN").getter(getter(CreateTrailResponse::trailARN)).setter(setter(Builder::trailARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()).build();

    private static final SdkField<Boolean> LOG_FILE_VALIDATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("LogFileValidationEnabled")
            .getter(getter(CreateTrailResponse::logFileValidationEnabled)).setter(setter(Builder::logFileValidationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileValidationEnabled").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("CloudWatchLogsLogGroupArn")
            .getter(getter(CreateTrailResponse::cloudWatchLogsLogGroupArn)).setter(setter(Builder::cloudWatchLogsLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").build())
            .build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogsRoleArn").getter(getter(CreateTrailResponse::cloudWatchLogsRoleArn))
            .setter(setter(Builder::cloudWatchLogsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsRoleArn").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateTrailResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> IS_ORGANIZATION_TRAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsOrganizationTrail").getter(getter(CreateTrailResponse::isOrganizationTrail))
            .setter(setter(Builder::isOrganizationTrail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOrganizationTrail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, SNS_TOPIC_NAME_FIELD,
                    SNS_TOPIC_ARN_FIELD, INCLUDE_GLOBAL_SERVICE_EVENTS_FIELD, IS_MULTI_REGION_TRAIL_FIELD, TRAIL_ARN_FIELD,
                    LOG_FILE_VALIDATION_ENABLED_FIELD, CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD, CLOUD_WATCH_LOGS_ROLE_ARN_FIELD,
                    KMS_KEY_ID_FIELD, IS_ORGANIZATION_TRAIL_FIELD));

    private final String name;

    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String snsTopicName;

    private final String snsTopicARN;

    private final Boolean includeGlobalServiceEvents;

    private final Boolean isMultiRegionTrail;

    private final String trailARN;

    private final Boolean logFileValidationEnabled;

    private final String cloudWatchLogsLogGroupArn;

    private final String cloudWatchLogsRoleArn;

    private final String kmsKeyId;

    private final Boolean isOrganizationTrail;

    private CreateTrailResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicName = builder.snsTopicName;
        this.snsTopicARN = builder.snsTopicARN;
        this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
        this.isMultiRegionTrail = builder.isMultiRegionTrail;
        this.trailARN = builder.trailARN;
        this.logFileValidationEnabled = builder.logFileValidationEnabled;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.isOrganizationTrail = builder.isOrganizationTrail;
    }

    /**
     * <p>
     * Specifies the name of the trail.
     * </p>
     * 
     * @return Specifies the name of the trail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     * </p>
     * 
     * @return Specifies the name of the Amazon S3 bucket designated for publishing log files.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file
     * delivery. For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your
     * CloudTrail Log Files</a>.
     * </p>
     * 
     * @return Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log
     *         file delivery. For more information, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding
     *         Your CloudTrail Log Files</a>.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * This field is no longer in use. Use <code>SnsTopicARN</code>.
     * </p>
     * 
     * @return This field is no longer in use. Use <code>SnsTopicARN</code>.
     * @deprecated
     */
    @Deprecated
    public final String snsTopicName() {
        return snsTopicName;
    }

    /**
     * <p>
     * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are
     * delivered. The format of a topic ARN is:
     * </p>
     * <p>
     * <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
     * </p>
     * 
     * @return Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are
     *         delivered. The format of a topic ARN is:</p>
     *         <p>
     *         <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
     */
    public final String snsTopicARN() {
        return snsTopicARN;
    }

    /**
     * <p>
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     * </p>
     * 
     * @return Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    public final Boolean includeGlobalServiceEvents() {
        return includeGlobalServiceEvents;
    }

    /**
     * <p>
     * Specifies whether the trail exists in one Region or in all Regions.
     * </p>
     * 
     * @return Specifies whether the trail exists in one Region or in all Regions.
     */
    public final Boolean isMultiRegionTrail() {
        return isMultiRegionTrail;
    }

    /**
     * <p>
     * Specifies the ARN of the trail that was created. The format of a trail ARN is:
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * 
     * @return Specifies the ARN of the trail that was created. The format of a trail ARN is:</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     */
    public final String trailARN() {
        return trailARN;
    }

    /**
     * <p>
     * Specifies whether log file integrity validation is enabled.
     * </p>
     * 
     * @return Specifies whether log file integrity validation is enabled.
     */
    public final Boolean logFileValidationEnabled() {
        return logFileValidationEnabled;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.
     */
    public final String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     * </p>
     * 
     * @return Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    public final String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN to
     * a KMS key in the following format.
     * </p>
     * <p>
     * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     * </p>
     * 
     * @return Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified
     *         ARN to a KMS key in the following format.</p>
     *         <p>
     *         <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether the trail is an organization trail.
     * </p>
     * 
     * @return Specifies whether the trail is an organization trail.
     */
    public final Boolean isOrganizationTrail() {
        return isOrganizationTrail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(includeGlobalServiceEvents());
        hashCode = 31 * hashCode + Objects.hashCode(isMultiRegionTrail());
        hashCode = 31 * hashCode + Objects.hashCode(trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(logFileValidationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(isOrganizationTrail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrailResponse)) {
            return false;
        }
        CreateTrailResponse other = (CreateTrailResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(snsTopicName(), other.snsTopicName())
                && Objects.equals(snsTopicARN(), other.snsTopicARN())
                && Objects.equals(includeGlobalServiceEvents(), other.includeGlobalServiceEvents())
                && Objects.equals(isMultiRegionTrail(), other.isMultiRegionTrail())
                && Objects.equals(trailARN(), other.trailARN())
                && Objects.equals(logFileValidationEnabled(), other.logFileValidationEnabled())
                && Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn())
                && Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(isOrganizationTrail(), other.isOrganizationTrail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrailResponse").add("Name", name()).add("S3BucketName", s3BucketName())
                .add("S3KeyPrefix", s3KeyPrefix()).add("SnsTopicName", snsTopicName()).add("SnsTopicARN", snsTopicARN())
                .add("IncludeGlobalServiceEvents", includeGlobalServiceEvents()).add("IsMultiRegionTrail", isMultiRegionTrail())
                .add("TrailARN", trailARN()).add("LogFileValidationEnabled", logFileValidationEnabled())
                .add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn())
                .add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn()).add("KmsKeyId", kmsKeyId())
                .add("IsOrganizationTrail", isOrganizationTrail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "SnsTopicName":
            return Optional.ofNullable(clazz.cast(snsTopicName()));
        case "SnsTopicARN":
            return Optional.ofNullable(clazz.cast(snsTopicARN()));
        case "IncludeGlobalServiceEvents":
            return Optional.ofNullable(clazz.cast(includeGlobalServiceEvents()));
        case "IsMultiRegionTrail":
            return Optional.ofNullable(clazz.cast(isMultiRegionTrail()));
        case "TrailARN":
            return Optional.ofNullable(clazz.cast(trailARN()));
        case "LogFileValidationEnabled":
            return Optional.ofNullable(clazz.cast(logFileValidationEnabled()));
        case "CloudWatchLogsLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroupArn()));
        case "CloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "IsOrganizationTrail":
            return Optional.ofNullable(clazz.cast(isOrganizationTrail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrailResponse, T> g) {
        return obj -> g.apply((CreateTrailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrailResponse> {
        /**
         * <p>
         * Specifies the name of the trail.
         * </p>
         * 
         * @param name
         *        Specifies the name of the trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the name of the Amazon S3 bucket designated for publishing log files.
         * </p>
         * 
         * @param s3BucketName
         *        Specifies the name of the Amazon S3 bucket designated for publishing log files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file
         * delivery. For more information, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your
         * CloudTrail Log Files</a>.
         * </p>
         * 
         * @param s3KeyPrefix
         *        Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log
         *        file delivery. For more information, see <a
         *        href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html"
         *        >Finding Your CloudTrail Log Files</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * This field is no longer in use. Use <code>SnsTopicARN</code>.
         * </p>
         * 
         * @param snsTopicName
         *        This field is no longer in use. Use <code>SnsTopicARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder snsTopicName(String snsTopicName);

        /**
         * <p>
         * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are
         * delivered. The format of a topic ARN is:
         * </p>
         * <p>
         * <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
         * </p>
         * 
         * @param snsTopicARN
         *        Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files
         *        are delivered. The format of a topic ARN is:</p>
         *        <p>
         *        <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicARN(String snsTopicARN);

        /**
         * <p>
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * </p>
         * 
         * @param includeGlobalServiceEvents
         *        Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents);

        /**
         * <p>
         * Specifies whether the trail exists in one Region or in all Regions.
         * </p>
         * 
         * @param isMultiRegionTrail
         *        Specifies whether the trail exists in one Region or in all Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMultiRegionTrail(Boolean isMultiRegionTrail);

        /**
         * <p>
         * Specifies the ARN of the trail that was created. The format of a trail ARN is:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * 
         * @param trailARN
         *        Specifies the ARN of the trail that was created. The format of a trail ARN is:</p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailARN(String trailARN);

        /**
         * <p>
         * Specifies whether log file integrity validation is enabled.
         * </p>
         * 
         * @param logFileValidationEnabled
         *        Specifies whether log file integrity validation is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFileValidationEnabled(Boolean logFileValidationEnabled);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.
         * </p>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);

        /**
         * <p>
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);

        /**
         * <p>
         * Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN
         * to a KMS key in the following format.
         * </p>
         * <p>
         * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * </p>
         * 
         * @param kmsKeyId
         *        Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully
         *        specified ARN to a KMS key in the following format.</p>
         *        <p>
         *        <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether the trail is an organization trail.
         * </p>
         * 
         * @param isOrganizationTrail
         *        Specifies whether the trail is an organization trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOrganizationTrail(Boolean isOrganizationTrail);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String name;

        private String s3BucketName;

        private String s3KeyPrefix;

        private String snsTopicName;

        private String snsTopicARN;

        private Boolean includeGlobalServiceEvents;

        private Boolean isMultiRegionTrail;

        private String trailARN;

        private Boolean logFileValidationEnabled;

        private String cloudWatchLogsLogGroupArn;

        private String cloudWatchLogsRoleArn;

        private String kmsKeyId;

        private Boolean isOrganizationTrail;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrailResponse model) {
            super(model);
            name(model.name);
            s3BucketName(model.s3BucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            snsTopicName(model.snsTopicName);
            snsTopicARN(model.snsTopicARN);
            includeGlobalServiceEvents(model.includeGlobalServiceEvents);
            isMultiRegionTrail(model.isMultiRegionTrail);
            trailARN(model.trailARN);
            logFileValidationEnabled(model.logFileValidationEnabled);
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            kmsKeyId(model.kmsKeyId);
            isOrganizationTrail(model.isOrganizationTrail);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @Deprecated
        public final String getSnsTopicName() {
            return snsTopicName;
        }

        @Deprecated
        public final void setSnsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
        }

        @Override
        @Deprecated
        public final Builder snsTopicName(String snsTopicName) {
            this.snsTopicName = snsTopicName;
            return this;
        }

        public final String getSnsTopicARN() {
            return snsTopicARN;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final Boolean getIncludeGlobalServiceEvents() {
            return includeGlobalServiceEvents;
        }

        public final void setIncludeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
        }

        @Override
        public final Builder includeGlobalServiceEvents(Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        public final Boolean getIsMultiRegionTrail() {
            return isMultiRegionTrail;
        }

        public final void setIsMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
        }

        @Override
        public final Builder isMultiRegionTrail(Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        public final String getTrailARN() {
            return trailARN;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final Boolean getLogFileValidationEnabled() {
            return logFileValidationEnabled;
        }

        public final void setLogFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
        }

        @Override
        public final Builder logFileValidationEnabled(Boolean logFileValidationEnabled) {
            this.logFileValidationEnabled = logFileValidationEnabled;
            return this;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getIsOrganizationTrail() {
            return isOrganizationTrail;
        }

        public final void setIsOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
        }

        @Override
        public final Builder isOrganizationTrail(Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        @Override
        public CreateTrailResponse build() {
            return new CreateTrailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
