/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeIndexFields</code> request. Contains the index fields configured for the domain
 * specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIndexFieldsResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DescribeIndexFieldsResponse.Builder, DescribeIndexFieldsResponse> {
    private static final SdkField<List<IndexFieldStatus>> INDEX_FIELDS_FIELD = SdkField
            .<List<IndexFieldStatus>> builder(MarshallingType.LIST)
            .memberName("IndexFields")
            .getter(getter(DescribeIndexFieldsResponse::indexFields))
            .setter(setter(Builder::indexFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IndexFieldStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(IndexFieldStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELDS_FIELD));

    private final List<IndexFieldStatus> indexFields;

    private DescribeIndexFieldsResponse(BuilderImpl builder) {
        super(builder);
        this.indexFields = builder.indexFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the IndexFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIndexFields() {
        return indexFields != null && !(indexFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The index fields configured for the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexFields} method.
     * </p>
     * 
     * @return The index fields configured for the domain.
     */
    public final List<IndexFieldStatus> indexFields() {
        return indexFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexFields() ? indexFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsResponse)) {
            return false;
        }
        DescribeIndexFieldsResponse other = (DescribeIndexFieldsResponse) obj;
        return hasIndexFields() == other.hasIndexFields() && Objects.equals(indexFields(), other.indexFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIndexFieldsResponse").add("IndexFields", hasIndexFields() ? indexFields() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexFields":
            return Optional.ofNullable(clazz.cast(indexFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexFieldsResponse, T> g) {
        return obj -> g.apply((DescribeIndexFieldsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIndexFieldsResponse> {
        /**
         * <p>
         * The index fields configured for the domain.
         * </p>
         * 
         * @param indexFields
         *        The index fields configured for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFields(Collection<IndexFieldStatus> indexFields);

        /**
         * <p>
         * The index fields configured for the domain.
         * </p>
         * 
         * @param indexFields
         *        The index fields configured for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFields(IndexFieldStatus... indexFields);

        /**
         * <p>
         * The index fields configured for the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #indexFields(List<IndexFieldStatus>)}.
         * 
         * @param indexFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexFields(java.util.Collection<IndexFieldStatus>)
         */
        Builder indexFields(Consumer<IndexFieldStatus.Builder>... indexFields);
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private List<IndexFieldStatus> indexFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsResponse model) {
            super(model);
            indexFields(model.indexFields);
        }

        public final List<IndexFieldStatus.Builder> getIndexFields() {
            List<IndexFieldStatus.Builder> result = IndexFieldStatusListCopier.copyToBuilder(this.indexFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexFields(Collection<IndexFieldStatus.BuilderImpl> indexFields) {
            this.indexFields = IndexFieldStatusListCopier.copyFromBuilder(indexFields);
        }

        @Override
        public final Builder indexFields(Collection<IndexFieldStatus> indexFields) {
            this.indexFields = IndexFieldStatusListCopier.copy(indexFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexFields(IndexFieldStatus... indexFields) {
            indexFields(Arrays.asList(indexFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexFields(Consumer<IndexFieldStatus.Builder>... indexFields) {
            indexFields(Stream.of(indexFields).map(c -> IndexFieldStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIndexFieldsResponse build() {
            return new DescribeIndexFieldsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
