/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeExpressions</code> request. Contains the expressions configured for the domain
 * specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExpressionsResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DescribeExpressionsResponse.Builder, DescribeExpressionsResponse> {
    private static final SdkField<List<ExpressionStatus>> EXPRESSIONS_FIELD = SdkField
            .<List<ExpressionStatus>> builder(MarshallingType.LIST)
            .memberName("Expressions")
            .getter(getter(DescribeExpressionsResponse::expressions))
            .setter(setter(Builder::expressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expressions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpressionStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpressionStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSIONS_FIELD));

    private final List<ExpressionStatus> expressions;

    private DescribeExpressionsResponse(BuilderImpl builder) {
        super(builder);
        this.expressions = builder.expressions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Expressions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExpressions() {
        return expressions != null && !(expressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The expressions configured for the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpressions} method.
     * </p>
     * 
     * @return The expressions configured for the domain.
     */
    public final List<ExpressionStatus> expressions() {
        return expressions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExpressions() ? expressions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExpressionsResponse)) {
            return false;
        }
        DescribeExpressionsResponse other = (DescribeExpressionsResponse) obj;
        return hasExpressions() == other.hasExpressions() && Objects.equals(expressions(), other.expressions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExpressionsResponse").add("Expressions", hasExpressions() ? expressions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expressions":
            return Optional.ofNullable(clazz.cast(expressions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExpressionsResponse, T> g) {
        return obj -> g.apply((DescribeExpressionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExpressionsResponse> {
        /**
         * <p>
         * The expressions configured for the domain.
         * </p>
         * 
         * @param expressions
         *        The expressions configured for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressions(Collection<ExpressionStatus> expressions);

        /**
         * <p>
         * The expressions configured for the domain.
         * </p>
         * 
         * @param expressions
         *        The expressions configured for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressions(ExpressionStatus... expressions);

        /**
         * <p>
         * The expressions configured for the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #expressions(List<ExpressionStatus>)}.
         * 
         * @param expressions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expressions(java.util.Collection<ExpressionStatus>)
         */
        Builder expressions(Consumer<ExpressionStatus.Builder>... expressions);
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private List<ExpressionStatus> expressions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExpressionsResponse model) {
            super(model);
            expressions(model.expressions);
        }

        public final List<ExpressionStatus.Builder> getExpressions() {
            List<ExpressionStatus.Builder> result = ExpressionStatusListCopier.copyToBuilder(this.expressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpressions(Collection<ExpressionStatus.BuilderImpl> expressions) {
            this.expressions = ExpressionStatusListCopier.copyFromBuilder(expressions);
        }

        @Override
        public final Builder expressions(Collection<ExpressionStatus> expressions) {
            this.expressions = ExpressionStatusListCopier.copy(expressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressions(ExpressionStatus... expressions) {
            expressions(Arrays.asList(expressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressions(Consumer<ExpressionStatus.Builder>... expressions) {
            expressions(Stream.of(expressions).map(c -> ExpressionStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeExpressionsResponse build() {
            return new DescribeExpressionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
