/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.KeyValueStore;
import software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse;

public class ListKeyValueStoresIterable
implements SdkIterable<ListKeyValueStoresResponse> {
    private final CloudFrontClient client;
    private final ListKeyValueStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeyValueStoresIterable(CloudFrontClient client, ListKeyValueStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKeyValueStoresResponseFetcher();
    }

    public Iterator<ListKeyValueStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KeyValueStore> items() {
        Function<ListKeyValueStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.keyValueStoreList() != null && response.keyValueStoreList().items() != null) {
                return response.keyValueStoreList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKeyValueStoresResponseFetcher
    implements SyncPageFetcher<ListKeyValueStoresResponse> {
        private ListKeyValueStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyValueStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.keyValueStoreList().nextMarker());
        }

        public ListKeyValueStoresResponse nextPage(ListKeyValueStoresResponse previousPage) {
            if (previousPage == null) {
                return ListKeyValueStoresIterable.this.client.listKeyValueStores(ListKeyValueStoresIterable.this.firstRequest);
            }
            return ListKeyValueStoresIterable.this.client.listKeyValueStores((ListKeyValueStoresRequest)((Object)ListKeyValueStoresIterable.this.firstRequest.toBuilder().marker(previousPage.keyValueStoreList().nextMarker()).build()));
        }
    }
}

