/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateFunctionRequest.Builder, UpdateFunctionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(UpdateFunctionRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").unmarshallLocationName("Name")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateFunctionRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final SdkField<FunctionConfig> FUNCTION_CONFIG_FIELD = SdkField
            .<FunctionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("FunctionConfig")
            .getter(getter(UpdateFunctionRequest::functionConfig))
            .setter(setter(Builder::functionConfig))
            .constructor(FunctionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionConfig")
                    .unmarshallLocationName("FunctionConfig").build()).build();

    private static final SdkField<SdkBytes> FUNCTION_CODE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("FunctionCode")
            .getter(getter(UpdateFunctionRequest::functionCode))
            .setter(setter(Builder::functionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionCode")
                    .unmarshallLocationName("FunctionCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IF_MATCH_FIELD,
            FUNCTION_CONFIG_FIELD, FUNCTION_CODE_FIELD));

    private final String name;

    private final String ifMatch;

    private final FunctionConfig functionConfig;

    private final SdkBytes functionCode;

    private UpdateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ifMatch = builder.ifMatch;
        this.functionConfig = builder.functionConfig;
        this.functionCode = builder.functionCode;
    }

    /**
     * <p>
     * The name of the function that you are updating.
     * </p>
     * 
     * @return The name of the function that you are updating.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current version (<code>ETag</code> value) of the function that you are updating, which you can get using
     * <code>DescribeFunction</code>.
     * </p>
     * 
     * @return The current version (<code>ETag</code> value) of the function that you are updating, which you can get
     *         using <code>DescribeFunction</code>.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * <p>
     * Configuration information about the function.
     * </p>
     * 
     * @return Configuration information about the function.
     */
    public final FunctionConfig functionConfig() {
        return functionConfig;
    }

    /**
     * <p>
     * The function code. For more information about writing a CloudFront function, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing
     * function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The function code. For more information about writing a CloudFront function, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html"
     *         >Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final SdkBytes functionCode() {
        return functionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(functionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(functionCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionRequest)) {
            return false;
        }
        UpdateFunctionRequest other = (UpdateFunctionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ifMatch(), other.ifMatch())
                && Objects.equals(functionConfig(), other.functionConfig())
                && Objects.equals(functionCode(), other.functionCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFunctionRequest").add("Name", name()).add("IfMatch", ifMatch())
                .add("FunctionConfig", functionConfig())
                .add("FunctionCode", functionCode() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "FunctionConfig":
            return Optional.ofNullable(clazz.cast(functionConfig()));
        case "FunctionCode":
            return Optional.ofNullable(clazz.cast(functionCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionRequest, T> g) {
        return obj -> g.apply((UpdateFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFunctionRequest> {
        /**
         * <p>
         * The name of the function that you are updating.
         * </p>
         * 
         * @param name
         *        The name of the function that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current version (<code>ETag</code> value) of the function that you are updating, which you can get using
         * <code>DescribeFunction</code>.
         * </p>
         * 
         * @param ifMatch
         *        The current version (<code>ETag</code> value) of the function that you are updating, which you can get
         *        using <code>DescribeFunction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * Configuration information about the function.
         * </p>
         * 
         * @param functionConfig
         *        Configuration information about the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionConfig(FunctionConfig functionConfig);

        /**
         * <p>
         * Configuration information about the function.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionConfig.Builder} avoiding the need
         * to create one manually via {@link FunctionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #functionConfig(FunctionConfig)}.
         * 
         * @param functionConfig
         *        a consumer that will call methods on {@link FunctionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionConfig(FunctionConfig)
         */
        default Builder functionConfig(Consumer<FunctionConfig.Builder> functionConfig) {
            return functionConfig(FunctionConfig.builder().applyMutation(functionConfig).build());
        }

        /**
         * <p>
         * The function code. For more information about writing a CloudFront function, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing
         * function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param functionCode
         *        The function code. For more information about writing a CloudFront function, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html"
         *        >Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionCode(SdkBytes functionCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String name;

        private String ifMatch;

        private FunctionConfig functionConfig;

        private SdkBytes functionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionRequest model) {
            super(model);
            name(model.name);
            ifMatch(model.ifMatch);
            functionConfig(model.functionConfig);
            functionCode(model.functionCode);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final FunctionConfig.Builder getFunctionConfig() {
            return functionConfig != null ? functionConfig.toBuilder() : null;
        }

        public final void setFunctionConfig(FunctionConfig.BuilderImpl functionConfig) {
            this.functionConfig = functionConfig != null ? functionConfig.build() : null;
        }

        @Override
        public final Builder functionConfig(FunctionConfig functionConfig) {
            this.functionConfig = functionConfig;
            return this;
        }

        public final ByteBuffer getFunctionCode() {
            return functionCode == null ? null : functionCode.asByteBuffer();
        }

        public final void setFunctionCode(ByteBuffer functionCode) {
            functionCode(functionCode == null ? null : SdkBytes.fromByteBuffer(functionCode));
        }

        @Override
        public final Builder functionCode(SdkBytes functionCode) {
            this.functionCode = functionCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionRequest build() {
            return new UpdateFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
