/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The traffic configuration of your continuous deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficConfig implements SdkPojo, Serializable, ToCopyableBuilder<TrafficConfig.Builder, TrafficConfig> {
    private static final SdkField<ContinuousDeploymentSingleWeightConfig> SINGLE_WEIGHT_CONFIG_FIELD = SdkField
            .<ContinuousDeploymentSingleWeightConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SingleWeightConfig")
            .getter(getter(TrafficConfig::singleWeightConfig))
            .setter(setter(Builder::singleWeightConfig))
            .constructor(ContinuousDeploymentSingleWeightConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleWeightConfig")
                    .unmarshallLocationName("SingleWeightConfig").build()).build();

    private static final SdkField<ContinuousDeploymentSingleHeaderConfig> SINGLE_HEADER_CONFIG_FIELD = SdkField
            .<ContinuousDeploymentSingleHeaderConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SingleHeaderConfig")
            .getter(getter(TrafficConfig::singleHeaderConfig))
            .setter(setter(Builder::singleHeaderConfig))
            .constructor(ContinuousDeploymentSingleHeaderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleHeaderConfig")
                    .unmarshallLocationName("SingleHeaderConfig").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(TrafficConfig::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINGLE_WEIGHT_CONFIG_FIELD,
            SINGLE_HEADER_CONFIG_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContinuousDeploymentSingleWeightConfig singleWeightConfig;

    private final ContinuousDeploymentSingleHeaderConfig singleHeaderConfig;

    private final String type;

    private TrafficConfig(BuilderImpl builder) {
        this.singleWeightConfig = builder.singleWeightConfig;
        this.singleHeaderConfig = builder.singleHeaderConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains the percentage of traffic to send to the staging distribution.
     * </p>
     * 
     * @return Contains the percentage of traffic to send to the staging distribution.
     */
    public final ContinuousDeploymentSingleWeightConfig singleWeightConfig() {
        return singleWeightConfig;
    }

    /**
     * <p>
     * Determines which HTTP requests are sent to the staging distribution.
     * </p>
     * 
     * @return Determines which HTTP requests are sent to the staging distribution.
     */
    public final ContinuousDeploymentSingleHeaderConfig singleHeaderConfig() {
        return singleHeaderConfig;
    }

    /**
     * <p>
     * The type of traffic configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContinuousDeploymentPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of traffic configuration.
     * @see ContinuousDeploymentPolicyType
     */
    public final ContinuousDeploymentPolicyType type() {
        return ContinuousDeploymentPolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of traffic configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContinuousDeploymentPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of traffic configuration.
     * @see ContinuousDeploymentPolicyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(singleWeightConfig());
        hashCode = 31 * hashCode + Objects.hashCode(singleHeaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficConfig)) {
            return false;
        }
        TrafficConfig other = (TrafficConfig) obj;
        return Objects.equals(singleWeightConfig(), other.singleWeightConfig())
                && Objects.equals(singleHeaderConfig(), other.singleHeaderConfig())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficConfig").add("SingleWeightConfig", singleWeightConfig())
                .add("SingleHeaderConfig", singleHeaderConfig()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SingleWeightConfig":
            return Optional.ofNullable(clazz.cast(singleWeightConfig()));
        case "SingleHeaderConfig":
            return Optional.ofNullable(clazz.cast(singleHeaderConfig()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficConfig, T> g) {
        return obj -> g.apply((TrafficConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficConfig> {
        /**
         * <p>
         * Contains the percentage of traffic to send to the staging distribution.
         * </p>
         * 
         * @param singleWeightConfig
         *        Contains the percentage of traffic to send to the staging distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleWeightConfig(ContinuousDeploymentSingleWeightConfig singleWeightConfig);

        /**
         * <p>
         * Contains the percentage of traffic to send to the staging distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContinuousDeploymentSingleWeightConfig.Builder} avoiding the need to create one manually via
         * {@link ContinuousDeploymentSingleWeightConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContinuousDeploymentSingleWeightConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #singleWeightConfig(ContinuousDeploymentSingleWeightConfig)}.
         * 
         * @param singleWeightConfig
         *        a consumer that will call methods on {@link ContinuousDeploymentSingleWeightConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleWeightConfig(ContinuousDeploymentSingleWeightConfig)
         */
        default Builder singleWeightConfig(Consumer<ContinuousDeploymentSingleWeightConfig.Builder> singleWeightConfig) {
            return singleWeightConfig(ContinuousDeploymentSingleWeightConfig.builder().applyMutation(singleWeightConfig).build());
        }

        /**
         * <p>
         * Determines which HTTP requests are sent to the staging distribution.
         * </p>
         * 
         * @param singleHeaderConfig
         *        Determines which HTTP requests are sent to the staging distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleHeaderConfig(ContinuousDeploymentSingleHeaderConfig singleHeaderConfig);

        /**
         * <p>
         * Determines which HTTP requests are sent to the staging distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContinuousDeploymentSingleHeaderConfig.Builder} avoiding the need to create one manually via
         * {@link ContinuousDeploymentSingleHeaderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContinuousDeploymentSingleHeaderConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #singleHeaderConfig(ContinuousDeploymentSingleHeaderConfig)}.
         * 
         * @param singleHeaderConfig
         *        a consumer that will call methods on {@link ContinuousDeploymentSingleHeaderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleHeaderConfig(ContinuousDeploymentSingleHeaderConfig)
         */
        default Builder singleHeaderConfig(Consumer<ContinuousDeploymentSingleHeaderConfig.Builder> singleHeaderConfig) {
            return singleHeaderConfig(ContinuousDeploymentSingleHeaderConfig.builder().applyMutation(singleHeaderConfig).build());
        }

        /**
         * <p>
         * The type of traffic configuration.
         * </p>
         * 
         * @param type
         *        The type of traffic configuration.
         * @see ContinuousDeploymentPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinuousDeploymentPolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of traffic configuration.
         * </p>
         * 
         * @param type
         *        The type of traffic configuration.
         * @see ContinuousDeploymentPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinuousDeploymentPolicyType
         */
        Builder type(ContinuousDeploymentPolicyType type);
    }

    static final class BuilderImpl implements Builder {
        private ContinuousDeploymentSingleWeightConfig singleWeightConfig;

        private ContinuousDeploymentSingleHeaderConfig singleHeaderConfig;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficConfig model) {
            singleWeightConfig(model.singleWeightConfig);
            singleHeaderConfig(model.singleHeaderConfig);
            type(model.type);
        }

        public final ContinuousDeploymentSingleWeightConfig.Builder getSingleWeightConfig() {
            return singleWeightConfig != null ? singleWeightConfig.toBuilder() : null;
        }

        public final void setSingleWeightConfig(ContinuousDeploymentSingleWeightConfig.BuilderImpl singleWeightConfig) {
            this.singleWeightConfig = singleWeightConfig != null ? singleWeightConfig.build() : null;
        }

        @Override
        public final Builder singleWeightConfig(ContinuousDeploymentSingleWeightConfig singleWeightConfig) {
            this.singleWeightConfig = singleWeightConfig;
            return this;
        }

        public final ContinuousDeploymentSingleHeaderConfig.Builder getSingleHeaderConfig() {
            return singleHeaderConfig != null ? singleHeaderConfig.toBuilder() : null;
        }

        public final void setSingleHeaderConfig(ContinuousDeploymentSingleHeaderConfig.BuilderImpl singleHeaderConfig) {
            this.singleHeaderConfig = singleHeaderConfig != null ? singleHeaderConfig.build() : null;
        }

        @Override
        public final Builder singleHeaderConfig(ContinuousDeploymentSingleHeaderConfig singleHeaderConfig) {
            this.singleHeaderConfig = singleHeaderConfig;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContinuousDeploymentPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public TrafficConfig build() {
            return new TrafficConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
