/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;

public class DescribeStackResourceDriftsIterable
implements SdkIterable<DescribeStackResourceDriftsResponse> {
    private final CloudFormationClient client;
    private final DescribeStackResourceDriftsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStackResourceDriftsIterable(CloudFormationClient client, DescribeStackResourceDriftsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeStackResourceDriftsResponseFetcher();
    }

    public Iterator<DescribeStackResourceDriftsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeStackResourceDriftsResponseFetcher
    implements SyncPageFetcher<DescribeStackResourceDriftsResponse> {
        private DescribeStackResourceDriftsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStackResourceDriftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStackResourceDriftsResponse nextPage(DescribeStackResourceDriftsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStackResourceDriftsIterable.this.client.describeStackResourceDrifts(DescribeStackResourceDriftsIterable.this.firstRequest);
            }
            return DescribeStackResourceDriftsIterable.this.client.describeStackResourceDrifts((DescribeStackResourceDriftsRequest)((Object)DescribeStackResourceDriftsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

