/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StackSetOperationStatus {
    RUNNING("RUNNING"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    QUEUED("QUEUED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StackSetOperationStatus> VALUE_MAP;
    private final String value;

    private StackSetOperationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackSetOperationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackSetOperationStatus> knownValues() {
        EnumSet<StackSetOperationStatus> knownValues = EnumSet.allOf(StackSetOperationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StackSetOperationStatus.class, StackSetOperationStatus::toString);
    }
}

