/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the <code>PolicyType</code>, <code>PolicyId</code>, and the <code>ObjectIdentifier</code> to which it is
 * attached. For more information, see <a href=
 * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
 * >Policies</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyAttachment.Builder, PolicyAttachment> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(PolicyAttachment::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectIdentifier").getter(getter(PolicyAttachment::objectIdentifier))
            .setter(setter(Builder::objectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(PolicyAttachment::policyType)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            OBJECT_IDENTIFIER_FIELD, POLICY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final String objectIdentifier;

    private final String policyType;

    private PolicyAttachment(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.objectIdentifier = builder.objectIdentifier;
        this.policyType = builder.policyType;
    }

    /**
     * <p>
     * The ID of <code>PolicyAttachment</code>.
     * </p>
     * 
     * @return The ID of <code>PolicyAttachment</code>.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.
     * </p>
     * 
     * @return The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.
     */
    public final String objectIdentifier() {
        return objectIdentifier;
    }

    /**
     * <p>
     * The type of policy that can be associated with <code>PolicyAttachment</code>.
     * </p>
     * 
     * @return The type of policy that can be associated with <code>PolicyAttachment</code>.
     */
    public final String policyType() {
        return policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(policyType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyAttachment)) {
            return false;
        }
        PolicyAttachment other = (PolicyAttachment) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(objectIdentifier(), other.objectIdentifier())
                && Objects.equals(policyType(), other.policyType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyAttachment").add("PolicyId", policyId()).add("ObjectIdentifier", objectIdentifier())
                .add("PolicyType", policyType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "ObjectIdentifier":
            return Optional.ofNullable(clazz.cast(objectIdentifier()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyAttachment, T> g) {
        return obj -> g.apply((PolicyAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyAttachment> {
        /**
         * <p>
         * The ID of <code>PolicyAttachment</code>.
         * </p>
         * 
         * @param policyId
         *        The ID of <code>PolicyAttachment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.
         * </p>
         * 
         * @param objectIdentifier
         *        The <code>ObjectIdentifier</code> that is associated with <code>PolicyAttachment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifier(String objectIdentifier);

        /**
         * <p>
         * The type of policy that can be associated with <code>PolicyAttachment</code>.
         * </p>
         * 
         * @param policyType
         *        The type of policy that can be associated with <code>PolicyAttachment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyType(String policyType);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private String objectIdentifier;

        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyAttachment model) {
            policyId(model.policyId);
            objectIdentifier(model.objectIdentifier);
            policyType(model.policyType);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getObjectIdentifier() {
            return objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public PolicyAttachment build() {
            return new PolicyAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
