/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttachedIndicesResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListAttachedIndicesResponse.Builder, ListAttachedIndicesResponse> {
    private static final SdkField<List<IndexAttachment>> INDEX_ATTACHMENTS_FIELD = SdkField
            .<List<IndexAttachment>> builder(MarshallingType.LIST)
            .memberName("IndexAttachments")
            .getter(getter(ListAttachedIndicesResponse::indexAttachments))
            .setter(setter(Builder::indexAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IndexAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(IndexAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAttachedIndicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ATTACHMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<IndexAttachment> indexAttachments;

    private final String nextToken;

    private ListAttachedIndicesResponse(BuilderImpl builder) {
        super(builder);
        this.indexAttachments = builder.indexAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IndexAttachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIndexAttachments() {
        return indexAttachments != null && !(indexAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The indices attached to the specified object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexAttachments} method.
     * </p>
     * 
     * @return The indices attached to the specified object.
     */
    public final List<IndexAttachment> indexAttachments() {
        return indexAttachments;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexAttachments() ? indexAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedIndicesResponse)) {
            return false;
        }
        ListAttachedIndicesResponse other = (ListAttachedIndicesResponse) obj;
        return hasIndexAttachments() == other.hasIndexAttachments()
                && Objects.equals(indexAttachments(), other.indexAttachments()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttachedIndicesResponse")
                .add("IndexAttachments", hasIndexAttachments() ? indexAttachments() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexAttachments":
            return Optional.ofNullable(clazz.cast(indexAttachments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttachedIndicesResponse, T> g) {
        return obj -> g.apply((ListAttachedIndicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAttachedIndicesResponse> {
        /**
         * <p>
         * The indices attached to the specified object.
         * </p>
         * 
         * @param indexAttachments
         *        The indices attached to the specified object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexAttachments(Collection<IndexAttachment> indexAttachments);

        /**
         * <p>
         * The indices attached to the specified object.
         * </p>
         * 
         * @param indexAttachments
         *        The indices attached to the specified object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexAttachments(IndexAttachment... indexAttachments);

        /**
         * <p>
         * The indices attached to the specified object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.clouddirectory.model.IndexAttachment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.clouddirectory.model.IndexAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.clouddirectory.model.IndexAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #indexAttachments(List<IndexAttachment>)}.
         * 
         * @param indexAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.clouddirectory.model.IndexAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexAttachments(java.util.Collection<IndexAttachment>)
         */
        Builder indexAttachments(Consumer<IndexAttachment.Builder>... indexAttachments);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<IndexAttachment> indexAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedIndicesResponse model) {
            super(model);
            indexAttachments(model.indexAttachments);
            nextToken(model.nextToken);
        }

        public final List<IndexAttachment.Builder> getIndexAttachments() {
            List<IndexAttachment.Builder> result = IndexAttachmentListCopier.copyToBuilder(this.indexAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexAttachments(Collection<IndexAttachment.BuilderImpl> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copyFromBuilder(indexAttachments);
        }

        @Override
        public final Builder indexAttachments(Collection<IndexAttachment> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copy(indexAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(IndexAttachment... indexAttachments) {
            indexAttachments(Arrays.asList(indexAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(Consumer<IndexAttachment.Builder>... indexAttachments) {
            indexAttachments(Stream.of(indexAttachments).map(c -> IndexAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAttachedIndicesResponse build() {
            return new ListAttachedIndicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
