/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishSchemaRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<PublishSchemaRequest.Builder, PublishSchemaRequest> {
    private static final SdkField<String> DEVELOPMENT_SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DevelopmentSchemaArn").getter(getter(PublishSchemaRequest::developmentSchemaArn))
            .setter(setter(Builder::developmentSchemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(PublishSchemaRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinorVersion").getter(getter(PublishSchemaRequest::minorVersion)).setter(setter(Builder::minorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinorVersion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PublishSchemaRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVELOPMENT_SCHEMA_ARN_FIELD,
            VERSION_FIELD, MINOR_VERSION_FIELD, NAME_FIELD));

    private final String developmentSchemaArn;

    private final String version;

    private final String minorVersion;

    private final String name;

    private PublishSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.developmentSchemaArn = builder.developmentSchemaArn;
        this.version = builder.version;
        this.minorVersion = builder.minorVersion;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see
     * <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see
     *         <a>arns</a>.
     */
    public final String developmentSchemaArn() {
        return developmentSchemaArn;
    }

    /**
     * <p>
     * The major version under which the schema will be published. Schemas have both a major and minor version
     * associated with them.
     * </p>
     * 
     * @return The major version under which the schema will be published. Schemas have both a major and minor version
     *         associated with them.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The minor version under which the schema will be published. This parameter is recommended. Schemas have both a
     * major and minor version associated with them.
     * </p>
     * 
     * @return The minor version under which the schema will be published. This parameter is recommended. Schemas have
     *         both a major and minor version associated with them.
     */
    public final String minorVersion() {
        return minorVersion;
    }

    /**
     * <p>
     * The new name under which the schema will be published. If this is not provided, the development schema is
     * considered.
     * </p>
     * 
     * @return The new name under which the schema will be published. If this is not provided, the development schema is
     *         considered.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(developmentSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishSchemaRequest)) {
            return false;
        }
        PublishSchemaRequest other = (PublishSchemaRequest) obj;
        return Objects.equals(developmentSchemaArn(), other.developmentSchemaArn()) && Objects.equals(version(), other.version())
                && Objects.equals(minorVersion(), other.minorVersion()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishSchemaRequest").add("DevelopmentSchemaArn", developmentSchemaArn())
                .add("Version", version()).add("MinorVersion", minorVersion()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevelopmentSchemaArn":
            return Optional.ofNullable(clazz.cast(developmentSchemaArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "MinorVersion":
            return Optional.ofNullable(clazz.cast(minorVersion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishSchemaRequest, T> g) {
        return obj -> g.apply((PublishSchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishSchemaRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see
         * <a>arns</a>.
         * </p>
         * 
         * @param developmentSchemaArn
         *        The Amazon Resource Name (ARN) that is associated with the development schema. For more information,
         *        see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developmentSchemaArn(String developmentSchemaArn);

        /**
         * <p>
         * The major version under which the schema will be published. Schemas have both a major and minor version
         * associated with them.
         * </p>
         * 
         * @param version
         *        The major version under which the schema will be published. Schemas have both a major and minor
         *        version associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The minor version under which the schema will be published. This parameter is recommended. Schemas have both
         * a major and minor version associated with them.
         * </p>
         * 
         * @param minorVersion
         *        The minor version under which the schema will be published. This parameter is recommended. Schemas
         *        have both a major and minor version associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minorVersion(String minorVersion);

        /**
         * <p>
         * The new name under which the schema will be published. If this is not provided, the development schema is
         * considered.
         * </p>
         * 
         * @param name
         *        The new name under which the schema will be published. If this is not provided, the development schema
         *        is considered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String developmentSchemaArn;

        private String version;

        private String minorVersion;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishSchemaRequest model) {
            super(model);
            developmentSchemaArn(model.developmentSchemaArn);
            version(model.version);
            minorVersion(model.minorVersion);
            name(model.name);
        }

        public final String getDevelopmentSchemaArn() {
            return developmentSchemaArn;
        }

        public final void setDevelopmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
        }

        @Override
        public final Builder developmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getMinorVersion() {
            return minorVersion;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishSchemaRequest build() {
            return new PublishSchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
