/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFacetResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<GetFacetResponse.Builder, GetFacetResponse> {
    private static final SdkField<Facet> FACET_FIELD = SdkField.<Facet> builder(MarshallingType.SDK_POJO).memberName("Facet")
            .getter(getter(GetFacetResponse::facet)).setter(setter(Builder::facet)).constructor(Facet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACET_FIELD));

    private final Facet facet;

    private GetFacetResponse(BuilderImpl builder) {
        super(builder);
        this.facet = builder.facet;
    }

    /**
     * <p>
     * The <a>Facet</a> structure that is associated with the facet.
     * </p>
     * 
     * @return The <a>Facet</a> structure that is associated with the facet.
     */
    public final Facet facet() {
        return facet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(facet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFacetResponse)) {
            return false;
        }
        GetFacetResponse other = (GetFacetResponse) obj;
        return Objects.equals(facet(), other.facet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFacetResponse").add("Facet", facet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Facet":
            return Optional.ofNullable(clazz.cast(facet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFacetResponse, T> g) {
        return obj -> g.apply((GetFacetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFacetResponse> {
        /**
         * <p>
         * The <a>Facet</a> structure that is associated with the facet.
         * </p>
         * 
         * @param facet
         *        The <a>Facet</a> structure that is associated with the facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facet(Facet facet);

        /**
         * <p>
         * The <a>Facet</a> structure that is associated with the facet.
         * </p>
         * This is a convenience method that creates an instance of the {@link Facet.Builder} avoiding the need to
         * create one manually via {@link Facet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Facet.Builder#build()} is called immediately and its result is
         * passed to {@link #facet(Facet)}.
         * 
         * @param facet
         *        a consumer that will call methods on {@link Facet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facet(Facet)
         */
        default Builder facet(Consumer<Facet.Builder> facet) {
            return facet(Facet.builder().applyMutation(facet).build());
        }
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private Facet facet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFacetResponse model) {
            super(model);
            facet(model.facet);
        }

        public final Facet.Builder getFacet() {
            return facet != null ? facet.toBuilder() : null;
        }

        public final void setFacet(Facet.BuilderImpl facet) {
            this.facet = facet != null ? facet.build() : null;
        }

        @Override
        public final Builder facet(Facet facet) {
            this.facet = facet;
            return this;
        }

        @Override
        public GetFacetResponse build() {
            return new GetFacetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
