/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypedLinkFacet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypedLinkFacet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TypedLinkFacet.getter(TypedLinkFacet::name)).setter(TypedLinkFacet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<TypedLinkAttributeDefinition>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(TypedLinkFacet.getter(TypedLinkFacet::attributes)).setter(TypedLinkFacet.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypedLinkAttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IDENTITY_ATTRIBUTE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityAttributeOrder").getter(TypedLinkFacet.getter(TypedLinkFacet::identityAttributeOrder)).setter(TypedLinkFacet.setter(Builder::identityAttributeOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTES_FIELD, IDENTITY_ATTRIBUTE_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<TypedLinkAttributeDefinition> attributes;
    private final List<String> identityAttributeOrder;

    private TypedLinkFacet(BuilderImpl builder) {
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<TypedLinkAttributeDefinition> attributes() {
        return this.attributes;
    }

    public final boolean hasIdentityAttributeOrder() {
        return this.identityAttributeOrder != null && !(this.identityAttributeOrder instanceof SdkAutoConstructList);
    }

    public final List<String> identityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityAttributeOrder() ? this.identityAttributeOrder() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkFacet)) {
            return false;
        }
        TypedLinkFacet other = (TypedLinkFacet)obj;
        return Objects.equals(this.name(), other.name()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasIdentityAttributeOrder() == other.hasIdentityAttributeOrder() && Objects.equals(this.identityAttributeOrder(), other.identityAttributeOrder());
    }

    public final String toString() {
        return ToString.builder((String)"TypedLinkFacet").add("Name", (Object)this.name()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("IdentityAttributeOrder", this.hasIdentityAttributeOrder() ? this.identityAttributeOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "IdentityAttributeOrder": {
                return Optional.ofNullable(clazz.cast(this.identityAttributeOrder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkFacet, T> g) {
        return obj -> g.apply((TypedLinkFacet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<TypedLinkAttributeDefinition> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> identityAttributeOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkFacet model) {
            this.name(model.name);
            this.attributes(model.attributes);
            this.identityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<TypedLinkAttributeDefinition.Builder> getAttributes() {
            List<TypedLinkAttributeDefinition.Builder> result = TypedLinkAttributeDefinitionListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<TypedLinkAttributeDefinition.BuilderImpl> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TypedLinkAttributeDefinition ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<TypedLinkAttributeDefinition.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (TypedLinkAttributeDefinition)((TypedLinkAttributeDefinition.Builder)TypedLinkAttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getIdentityAttributeOrder() {
            if (this.identityAttributeOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identityAttributeOrder;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public TypedLinkFacet build() {
            return new TypedLinkFacet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypedLinkFacet> {
        public Builder name(String var1);

        public Builder attributes(Collection<TypedLinkAttributeDefinition> var1);

        public Builder attributes(TypedLinkAttributeDefinition ... var1);

        public Builder attributes(Consumer<TypedLinkAttributeDefinition.Builder> ... var1);

        public Builder identityAttributeOrder(Collection<String> var1);

        public Builder identityAttributeOrder(String ... var1);
    }
}

