/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetachObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDetachObject> {
    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParentReference").getter(BatchDetachObject.getter(BatchDetachObject::parentReference)).setter(BatchDetachObject.setter(Builder::parentReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()}).build();
    private static final SdkField<String> LINK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkName").getter(BatchDetachObject.getter(BatchDetachObject::linkName)).setter(BatchDetachObject.setter(Builder::linkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()}).build();
    private static final SdkField<String> BATCH_REFERENCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchReferenceName").getter(BatchDetachObject.getter(BatchDetachObject::batchReferenceName)).setter(BatchDetachObject.setter(Builder::batchReferenceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchReferenceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_REFERENCE_FIELD, LINK_NAME_FIELD, BATCH_REFERENCE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final ObjectReference parentReference;
    private final String linkName;
    private final String batchReferenceName;

    private BatchDetachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    public final ObjectReference parentReference() {
        return this.parentReference;
    }

    public final String linkName() {
        return this.linkName;
    }

    public final String batchReferenceName() {
        return this.batchReferenceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchReferenceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetachObject)) {
            return false;
        }
        BatchDetachObject other = (BatchDetachObject)obj;
        return Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName()) && Objects.equals(this.batchReferenceName(), other.batchReferenceName());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDetachObject").add("ParentReference", (Object)this.parentReference()).add("LinkName", (Object)this.linkName()).add("BatchReferenceName", (Object)this.batchReferenceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentReference": {
                return Optional.ofNullable(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
            case "BatchReferenceName": {
                return Optional.ofNullable(clazz.cast(this.batchReferenceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetachObject, T> g) {
        return obj -> g.apply((BatchDetachObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference parentReference;
        private String linkName;
        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetachObject model) {
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
            this.batchReferenceName(model.batchReferenceName);
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final String getBatchReferenceName() {
            return this.batchReferenceName;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public BatchDetachObject build() {
            return new BatchDetachObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDetachObject> {
        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder batchReferenceName(String var1);
    }
}

