/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PaymentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PaymentConfiguration.Builder, PaymentConfiguration> {
    private static final SdkField<QueryComputePaymentConfig> QUERY_COMPUTE_FIELD = SdkField
            .<QueryComputePaymentConfig> builder(MarshallingType.SDK_POJO).memberName("queryCompute")
            .getter(getter(PaymentConfiguration::queryCompute)).setter(setter(Builder::queryCompute))
            .constructor(QueryComputePaymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryCompute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_COMPUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final QueryComputePaymentConfig queryCompute;

    private PaymentConfiguration(BuilderImpl builder) {
        this.queryCompute = builder.queryCompute;
    }

    /**
     * <p>
     * The collaboration member's payment responsibilities set by the collaboration creator for query compute costs.
     * </p>
     * 
     * @return The collaboration member's payment responsibilities set by the collaboration creator for query compute
     *         costs.
     */
    public final QueryComputePaymentConfig queryCompute() {
        return queryCompute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryCompute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentConfiguration)) {
            return false;
        }
        PaymentConfiguration other = (PaymentConfiguration) obj;
        return Objects.equals(queryCompute(), other.queryCompute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PaymentConfiguration").add("QueryCompute", queryCompute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryCompute":
            return Optional.ofNullable(clazz.cast(queryCompute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PaymentConfiguration, T> g) {
        return obj -> g.apply((PaymentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PaymentConfiguration> {
        /**
         * <p>
         * The collaboration member's payment responsibilities set by the collaboration creator for query compute costs.
         * </p>
         * 
         * @param queryCompute
         *        The collaboration member's payment responsibilities set by the collaboration creator for query compute
         *        costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryCompute(QueryComputePaymentConfig queryCompute);

        /**
         * <p>
         * The collaboration member's payment responsibilities set by the collaboration creator for query compute costs.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryComputePaymentConfig.Builder}
         * avoiding the need to create one manually via {@link QueryComputePaymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryComputePaymentConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #queryCompute(QueryComputePaymentConfig)}.
         * 
         * @param queryCompute
         *        a consumer that will call methods on {@link QueryComputePaymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryCompute(QueryComputePaymentConfig)
         */
        default Builder queryCompute(Consumer<QueryComputePaymentConfig.Builder> queryCompute) {
            return queryCompute(QueryComputePaymentConfig.builder().applyMutation(queryCompute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QueryComputePaymentConfig queryCompute;

        private BuilderImpl() {
        }

        private BuilderImpl(PaymentConfiguration model) {
            queryCompute(model.queryCompute);
        }

        public final QueryComputePaymentConfig.Builder getQueryCompute() {
            return queryCompute != null ? queryCompute.toBuilder() : null;
        }

        public final void setQueryCompute(QueryComputePaymentConfig.BuilderImpl queryCompute) {
            this.queryCompute = queryCompute != null ? queryCompute.build() : null;
        }

        @Override
        public final Builder queryCompute(QueryComputePaymentConfig queryCompute) {
            this.queryCompute = queryCompute;
            return this;
        }

        @Override
        public PaymentConfiguration build() {
            return new PaymentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
