/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSchemaResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<BatchGetSchemaResponse.Builder, BatchGetSchemaResponse> {
    private static final SdkField<List<Schema>> SCHEMAS_FIELD = SdkField
            .<List<Schema>> builder(MarshallingType.LIST)
            .memberName("schemas")
            .getter(getter(BatchGetSchemaResponse::schemas))
            .setter(setter(Builder::schemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Schema> builder(MarshallingType.SDK_POJO)
                                            .constructor(Schema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetSchemaError>> ERRORS_FIELD = SdkField
            .<List<BatchGetSchemaError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetSchemaResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetSchemaError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetSchemaError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMAS_FIELD, ERRORS_FIELD));

    private final List<Schema> schemas;

    private final List<BatchGetSchemaError> errors;

    private BatchGetSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.schemas = builder.schemas;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schemas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchemas() {
        return schemas != null && !(schemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The retrieved list of schemas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemas} method.
     * </p>
     * 
     * @return The retrieved list of schemas.
     */
    public final List<Schema> schemas() {
        return schemas;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not be
     * retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Error reasons for schemas that could not be retrieved. One error is returned for every schema that could
     *         not be retrieved.
     */
    public final List<BatchGetSchemaError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemas() ? schemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSchemaResponse)) {
            return false;
        }
        BatchGetSchemaResponse other = (BatchGetSchemaResponse) obj;
        return hasSchemas() == other.hasSchemas() && Objects.equals(schemas(), other.schemas())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSchemaResponse").add("Schemas", hasSchemas() ? schemas() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemas":
            return Optional.ofNullable(clazz.cast(schemas()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSchemaResponse, T> g) {
        return obj -> g.apply((BatchGetSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetSchemaResponse> {
        /**
         * <p>
         * The retrieved list of schemas.
         * </p>
         * 
         * @param schemas
         *        The retrieved list of schemas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Collection<Schema> schemas);

        /**
         * <p>
         * The retrieved list of schemas.
         * </p>
         * 
         * @param schemas
         *        The retrieved list of schemas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Schema... schemas);

        /**
         * <p>
         * The retrieved list of schemas.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.Schema.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cleanrooms.model.Schema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.Schema.Builder#build()} is called immediately and its
         * result is passed to {@link #schemas(List<Schema>)}.
         * 
         * @param schemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemas(java.util.Collection<Schema>)
         */
        Builder schemas(Consumer<Schema.Builder>... schemas);

        /**
         * <p>
         * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not
         * be retrieved.
         * </p>
         * 
         * @param errors
         *        Error reasons for schemas that could not be retrieved. One error is returned for every schema that
         *        could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetSchemaError> errors);

        /**
         * <p>
         * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not
         * be retrieved.
         * </p>
         * 
         * @param errors
         *        Error reasons for schemas that could not be retrieved. One error is returned for every schema that
         *        could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetSchemaError... errors);

        /**
         * <p>
         * Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not
         * be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaError.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchGetSchemaError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetSchemaError>)
         */
        Builder errors(Consumer<BatchGetSchemaError.Builder>... errors);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private List<Schema> schemas = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetSchemaError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSchemaResponse model) {
            super(model);
            schemas(model.schemas);
            errors(model.errors);
        }

        public final List<Schema.Builder> getSchemas() {
            List<Schema.Builder> result = SchemaListCopier.copyToBuilder(this.schemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemas(Collection<Schema.BuilderImpl> schemas) {
            this.schemas = SchemaListCopier.copyFromBuilder(schemas);
        }

        @Override
        public final Builder schemas(Collection<Schema> schemas) {
            this.schemas = SchemaListCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Schema... schemas) {
            schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<Schema.Builder>... schemas) {
            schemas(Stream.of(schemas).map(c -> Schema.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetSchemaError.Builder> getErrors() {
            List<BatchGetSchemaError.Builder> result = BatchGetSchemaErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetSchemaError.BuilderImpl> errors) {
            this.errors = BatchGetSchemaErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetSchemaError> errors) {
            this.errors = BatchGetSchemaErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetSchemaError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetSchemaError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetSchemaError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSchemaResponse build() {
            return new BatchGetSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
